/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.conditional;

import java.util.function.Function;
import java.util.function.Supplier;
import net.kemitix.conditional.Action;
import net.kemitix.conditional.FalseCondition;
import net.kemitix.conditional.TrueCondition;

public interface Condition {
    public static Condition where(boolean clause) {
        if (clause) {
            return TrueCondition.TRUE;
        }
        return FalseCondition.FALSE;
    }

    public boolean isTrue();

    public boolean isFalse();

    default public Condition not() {
        return Condition.where(this.isFalse());
    }

    public Condition and(Supplier<Boolean> var1);

    default public Condition and(Condition other) {
        return Condition.where(this.isTrue()).and(other::isTrue);
    }

    default public Condition and(boolean other) {
        return Condition.where(this.isTrue()).and(Condition.where(other));
    }

    public Condition or(Supplier<Boolean> var1);

    default public Condition or(Condition other) {
        return Condition.where(this.isTrue()).or(other::isTrue);
    }

    default public Condition or(boolean other) {
        return Condition.where(this.isTrue()).or(Condition.where(other));
    }

    public Condition then(Action var1);

    public void otherwise(Action var1);

    default public Condition otherwise(Supplier<Boolean> clause) {
        return Condition.where(clause.get());
    }

    @Deprecated
    public void thenThrow(Exception var1) throws Exception;

    public void thenThrow(Supplier<Exception> var1) throws Exception;

    @Deprecated
    public void otherwiseThrow(Exception var1) throws Exception;

    public void otherwiseThrow(Supplier<Exception> var1) throws Exception;

    default public Condition flatMap(Function<Boolean, Condition> f) {
        return f.apply(this.isTrue());
    }
}

