/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.conditional;

import java.util.Optional;
import java.util.function.Supplier;
import net.kemitix.conditional.Value;

class TrueValueClause<T>
implements Value.ValueClause<T> {
    protected static final Value.ValueClause<?> TRUE = new TrueValueClause();

    TrueValueClause() {
    }

    @Override
    public Value.ValueClause<T> not() {
        return Value.where(false);
    }

    @Override
    public Value.ValueClause.ValueSupplier<T> then(Supplier<T> trueSupplier) {
        return new TrueValueSupplier<T>(trueSupplier);
    }

    @Override
    public Value.ValueClause<T> and(Supplier<Boolean> clause) {
        return Value.where(clause.get());
    }

    @Override
    public Value.ValueClause<T> or(Supplier<Boolean> clause) {
        return this;
    }

    private static final class TrueValueSupplier<T>
    implements Value.ValueClause.ValueSupplier<T> {
        private final Supplier<T> valueSupplier;

        @Override
        public T otherwise(Supplier<T> falseSupplier) {
            return this.valueSupplier.get();
        }

        @Override
        public Optional<T> optional() {
            return Optional.ofNullable(this.valueSupplier.get());
        }

        public TrueValueSupplier(Supplier<T> valueSupplier) {
            this.valueSupplier = valueSupplier;
        }
    }
}

