/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.conditional;

import java.util.Optional;
import java.util.function.Supplier;
import net.kemitix.conditional.Condition;
import net.kemitix.conditional.FalseValueClause;
import net.kemitix.conditional.TrueValueClause;

public interface Value {
    public static <T> T where(boolean clause, Supplier<T> trueSupplier, Supplier<T> falseSupplier) {
        return Value.where(clause).then(trueSupplier).otherwise(falseSupplier);
    }

    public static <T> T where(Condition clause, Supplier<T> trueSupplier, Supplier<T> falseSupplier) {
        return Value.where(clause.isTrue(), trueSupplier, falseSupplier);
    }

    public static <T> Optional<T> where(boolean clause, Supplier<T> trueSupplier) {
        return Optional.ofNullable(Value.where(clause, trueSupplier, () -> null));
    }

    public static <T> Optional<T> where(Condition clause, Supplier<T> trueSupplier) {
        return Value.where(clause.isTrue(), trueSupplier);
    }

    public static <T> ValueClause<T> where(boolean clause) {
        if (clause) {
            return TrueValueClause.TRUE;
        }
        return FalseValueClause.FALSE;
    }

    public static <T> ValueClause<T> where(Condition clause) {
        return Value.where(clause.isTrue());
    }

    @Deprecated
    public static <T> ValueClause<T> whereNot(boolean clause) {
        return Value.where(!clause);
    }

    public static interface ValueClause<T> {
        public ValueClause<T> not();

        public ValueSupplier<T> then(Supplier<T> var1);

        public ValueClause<T> and(Supplier<Boolean> var1);

        public ValueClause<T> or(Supplier<Boolean> var1);

        default public ValueClause<T> andNot(Supplier<Boolean> clause) {
            return this.and(() -> (Boolean)clause.get() == false);
        }

        default public ValueClause<T> orNot(Supplier<Boolean> clause) {
            return this.or(() -> (Boolean)clause.get() == false);
        }

        public static interface ValueSupplier<T> {
            public T otherwise(Supplier<T> var1);

            public Optional<T> optional();
        }
    }
}

