/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.conditional;

import java.util.Optional;
import java.util.function.Supplier;
import net.kemitix.conditional.FalseValueClause;
import net.kemitix.conditional.TrueValueClause;

public interface Value {
    public static <T> T where(boolean clause, Supplier<T> trueSupplier, Supplier<T> falseSupplier) {
        return Value.where(clause).then(trueSupplier).otherwise(falseSupplier);
    }

    public static <T> Optional<T> where(boolean clause, Supplier<T> trueSupplier) {
        return Optional.ofNullable(Value.where(clause, trueSupplier, () -> null));
    }

    public static <T> ValueClause<T> where(boolean clause) {
        return clause ? TrueValueClause.TRUE : FalseValueClause.FALSE;
    }

    public static <T> ValueClause<T> whereNot(boolean clause) {
        return Value.where(!clause);
    }

    public static interface ValueClause<T> {
        public ValueSupplier<T> then(Supplier<T> var1);

        public ValueClause<T> and(boolean var1);

        public ValueClause<T> or(boolean var1);

        default public ValueClause<T> andNot(boolean clause) {
            return this.and(!clause);
        }

        default public ValueClause<T> orNot(boolean clause) {
            return this.or(!clause);
        }

        public static interface ValueSupplier<T> {
            public T otherwise(Supplier<T> var1);
        }
    }
}

