/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.conditional;

import java.util.function.Supplier;

public interface Value {
    public static <T> ValueClause<T> where(boolean clause) {
        if (clause) {
            return new TrueValueClause();
        }
        return new FalseValueClause();
    }

    public static <T> ValueClause<T> whereNot(boolean clause) {
        return Value.where(!clause);
    }

    public static class FalseValueClause<T>
    implements ValueClause<T> {
        @Override
        public ValueClause.ValueSupplier<T> then(Supplier<T> trueSupplier) {
            return new FalseValueSupplier();
        }

        @Override
        public ValueClause<T> and(boolean clause) {
            return this;
        }

        @Override
        public ValueClause<T> or(boolean clause) {
            return Value.where(clause);
        }

        private class FalseValueSupplier
        implements ValueClause.ValueSupplier<T> {
            private FalseValueSupplier() {
            }

            @Override
            public T otherwise(Supplier<T> falseSupplier) {
                return falseSupplier.get();
            }
        }
    }

    public static class TrueValueClause<T>
    implements ValueClause<T> {
        @Override
        public ValueClause.ValueSupplier<T> then(Supplier<T> trueSupplier) {
            return new TrueValueSupplier(trueSupplier);
        }

        @Override
        public ValueClause<T> and(boolean clause) {
            return Value.where(clause);
        }

        @Override
        public ValueClause<T> or(boolean clause) {
            return this;
        }

        private class TrueValueSupplier
        implements ValueClause.ValueSupplier<T> {
            private final Supplier<T> valueSupplier;

            TrueValueSupplier(Supplier<T> valueSupplier) {
                this.valueSupplier = valueSupplier;
            }

            @Override
            public T otherwise(Supplier<T> falseSupplier) {
                return this.valueSupplier.get();
            }
        }
    }

    public static interface ValueClause<T> {
        public ValueSupplier<T> then(Supplier<T> var1);

        public ValueClause<T> and(boolean var1);

        public ValueClause<T> or(boolean var1);

        default public ValueClause<T> andNot(boolean clause) {
            return this.and(!clause);
        }

        default public ValueClause<T> orNot(boolean clause) {
            return this.or(!clause);
        }

        public static interface ValueSupplier<T> {
            public T otherwise(Supplier<T> var1);
        }
    }
}

