/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.conditional;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Condition {
    public static final Condition TRUE = new TrueCondition();
    public static final Condition FALSE = new FalseCondition();
    public static final Map<Boolean, Condition> CONDITIONS = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<Boolean, Condition>(true, TRUE), new AbstractMap.SimpleEntry<Boolean, Condition>(false, FALSE)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));

    public static Condition where(boolean clause) {
        return CONDITIONS.get(clause);
    }

    public static Condition whereNot(boolean clause) {
        return Condition.where(!clause);
    }

    public Condition and(boolean var1);

    default public Condition andNot(boolean clause) {
        return this.and(!clause);
    }

    public Condition or(boolean var1);

    default public Condition orNot(boolean clause) {
        return this.or(!clause);
    }

    public Condition then(Runnable var1);

    public void otherwise(Runnable var1);

    default public Condition otherwise(boolean clause) {
        return Condition.where(clause);
    }

    public static class FalseCondition
    implements Condition {
        @Override
        public Condition and(boolean clause) {
            return FALSE;
        }

        @Override
        public Condition or(boolean secondClause) {
            return Condition.where(secondClause);
        }

        @Override
        public Condition then(Runnable response) {
            return FALSE;
        }

        @Override
        public void otherwise(Runnable response) {
            response.run();
        }
    }

    public static class TrueCondition
    implements Condition {
        @Override
        public Condition and(boolean clause) {
            return Condition.where(clause);
        }

        @Override
        public Condition or(boolean secondClause) {
            return TRUE;
        }

        @Override
        public Condition then(Runnable response) {
            response.run();
            return TRUE;
        }

        @Override
        public void otherwise(Runnable response) {
        }
    }
}

