/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.conditional;

public interface Condition {
    public static Condition where(boolean clause) {
        if (clause) {
            return TrueCondition.getInstance();
        }
        return FalseCondition.getInstance();
    }

    public static Condition whereNot(boolean clause) {
        return Condition.where(!clause);
    }

    public Condition and(boolean var1);

    default public Condition andNot(boolean clause) {
        return this.and(!clause);
    }

    public Condition or(boolean var1);

    default public Condition orNot(boolean clause) {
        return this.or(!clause);
    }

    public Condition then(Runnable var1);

    public void otherwise(Runnable var1);

    default public Condition otherwise(boolean clause) {
        return Condition.where(clause);
    }

    public static class FalseCondition
    implements Condition {
        private static final Condition INSTANCE = new FalseCondition();

        private static Condition getInstance() {
            return INSTANCE;
        }

        @Override
        public Condition and(boolean clause) {
            return this;
        }

        @Override
        public Condition or(boolean secondClause) {
            if (secondClause) {
                return TrueCondition.getInstance();
            }
            return this;
        }

        @Override
        public Condition then(Runnable response) {
            return this;
        }

        @Override
        public void otherwise(Runnable response) {
            response.run();
        }

        private FalseCondition() {
        }
    }

    public static class TrueCondition
    implements Condition {
        private static final Condition INSTANCE = new TrueCondition();

        private static Condition getInstance() {
            return INSTANCE;
        }

        @Override
        public Condition and(boolean clause) {
            if (clause) {
                return this;
            }
            return FalseCondition.getInstance();
        }

        @Override
        public Condition or(boolean secondClause) {
            return this;
        }

        @Override
        public Condition then(Runnable response) {
            response.run();
            return this;
        }

        @Override
        public void otherwise(Runnable response) {
        }

        private TrueCondition() {
        }
    }
}

