/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kemitix.checkstyle.ruleset.builder.Rule;
import net.kemitix.checkstyle.ruleset.builder.RuleReadmeLoader;
import net.kemitix.checkstyle.ruleset.builder.RuleSource;
import net.kemitix.checkstyle.ruleset.builder.RulesProperties;
import net.kemitix.checkstyle.ruleset.builder.SourcesProperties;
import org.springframework.stereotype.Component;

@Component
public class RuleLoader {
    private static final String NEWLINE = "\n";
    private final RulesProperties rulesProperties;
    private final RuleReadmeLoader ruleReadmeLoader;
    private final SourcesProperties sourcesProperties;

    public String loadEnabled(String sourceName) {
        if (!this.isEnabledRuleSource(sourceName)) {
            return "";
        }
        return this.readmeRules(rule -> rule.isFromSource(sourceName) && rule.isEnabled());
    }

    public String loadDisabled(String sourceName) {
        boolean enabledRuleSource = this.isEnabledRuleSource(sourceName);
        return this.readmeRules(rule -> rule.isFromSource(sourceName) && (!enabledRuleSource || !rule.isEnabled()));
    }

    private boolean isEnabledRuleSource(String sourceName) {
        return this.sourcesProperties.getSources().stream().filter(RuleSource::isEnabled).map(RuleSource::getName).anyMatch(sourceName::equals);
    }

    private String readmeRules(Predicate<Rule> predicate) {
        return this.rulesProperties.getRules().stream().filter(predicate).sorted(Rule::sortByName).flatMap(this.ruleReadmeLoader::load).collect(Collectors.joining(NEWLINE));
    }

    public RuleLoader(RulesProperties rulesProperties, RuleReadmeLoader ruleReadmeLoader, SourcesProperties sourcesProperties) {
        this.rulesProperties = rulesProperties;
        this.ruleReadmeLoader = ruleReadmeLoader;
        this.sourcesProperties = sourcesProperties;
    }
}

