/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import com.speedment.common.mapstream.MapStream;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kemitix.checkstyle.ruleset.builder.RuleLevel;
import net.kemitix.checkstyle.ruleset.builder.RuleParent;

public class Rule {
    private static final Locale LOCALE = Locale.ENGLISH;
    private static final String MODULE_NO_PROPERTIES = "<module name=\"%s\"/>";
    private static final String MODULE_WITH_PROPERTIES = "<module name=\"%s\">%n%s%n</module>";
    private final Map<String, String> properties = new HashMap<String, String>();
    private String name;
    private RuleParent parent;
    private RuleLevel level;
    private boolean enabled;
    private String source;
    private URI uri;
    private boolean insuppressible;
    private String reason;

    protected static int sortByName(Rule left, Rule right) {
        return left.getName().toLowerCase(LOCALE).compareTo(right.getName().toLowerCase(LOCALE));
    }

    static Predicate<Rule> hasParent(RuleParent ruleParent) {
        return rule -> ruleParent.equals((Object)rule.getParent());
    }

    static Predicate<Rule> isIncludedInLevel(RuleLevel ruleLevel) {
        return rule -> ruleLevel.compareTo(rule.getLevel()) >= 0;
    }

    private static String formatProperties(Map<String, String> properties) {
        return MapStream.of(properties).sorted(Comparator.comparing(Map.Entry::getKey)).map((k, v) -> String.format("        <property name=\"%s\" value=\"%s\"/>", k, v)).collect(Collectors.joining(System.lineSeparator()));
    }

    private static boolean hasProperties(Rule rule) {
        return !rule.getProperties().isEmpty();
    }

    static String asModule(String ruleClassname, Rule rule) {
        if (Rule.hasProperties(rule)) {
            return Rule.moduleWithParameters(rule, ruleClassname);
        }
        return Rule.moduleNoParameters(ruleClassname);
    }

    private static String moduleNoParameters(String ruleClassname) {
        return String.format(MODULE_NO_PROPERTIES, ruleClassname);
    }

    private static String moduleWithParameters(Rule rule, String ruleClassname) {
        return String.format(MODULE_WITH_PROPERTIES, ruleClassname, Rule.formatProperties(rule.getProperties()));
    }

    public boolean isFromSource(String sourceName) {
        return this.getSource().equals(sourceName);
    }

    public String getSource() {
        return this.source.toLowerCase(Locale.ENGLISH);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(RuleParent parent) {
        this.parent = parent;
    }

    public void setLevel(RuleLevel level) {
        this.level = level;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setInsuppressible(boolean insuppressible) {
        this.insuppressible = insuppressible;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }

    public RuleParent getParent() {
        return this.parent;
    }

    public RuleLevel getLevel() {
        return this.level;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isInsuppressible() {
        return this.insuppressible;
    }

    public String getReason() {
        return this.reason;
    }
}

