/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import java.io.File;
import java.nio.file.Paths;
import net.kemitix.checkstyle.ruleset.builder.OutputProperties;
import net.kemitix.checkstyle.ruleset.builder.ReadmeBuilder;
import net.kemitix.checkstyle.ruleset.builder.TemplateProperties;
import net.kemitix.files.FileReaderWriter;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
class ReadmeWriter
implements CommandLineRunner {
    private final TemplateProperties templateProperties;
    private final OutputProperties outputProperties;
    private final ReadmeBuilder readmeBuilder;
    private final FileReaderWriter fileReaderWriter;

    public void run(String ... args) throws Exception {
        File templateFile = this.templateProperties.getReadmeTemplate();
        String templateBody = this.fileReaderWriter.read(templateFile);
        File outputFile = Paths.get(this.outputProperties.getReadme(), new String[0]).toFile();
        String outputBody = this.readmeBuilder.build(templateBody);
        this.fileReaderWriter.write(outputFile, outputBody);
    }

    public ReadmeWriter(TemplateProperties templateProperties, OutputProperties outputProperties, ReadmeBuilder readmeBuilder, FileReaderWriter fileReaderWriter) {
        this.templateProperties = templateProperties;
        this.outputProperties = outputProperties;
        this.readmeBuilder = readmeBuilder;
        this.fileReaderWriter = fileReaderWriter;
    }
}

