/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import net.kemitix.checkstyle.ruleset.builder.ReadmeIndexBuilder;
import net.kemitix.checkstyle.ruleset.builder.RuleLoader;
import org.springframework.stereotype.Component;

@Component
public class ReadmeBuilder {
    public static final String CHECKSTYLE = "checkstyle";
    public static final String SEVNTU = "sevntu";
    private final ReadmeIndexBuilder indexBuilder;
    private final RuleLoader ruleLoader;

    public String build(String readmeTemplate) {
        String enabledCheckstyle = this.ruleLoader.loadEnabled(CHECKSTYLE);
        String enabledSevntu = this.ruleLoader.loadEnabled(SEVNTU);
        String disabledCheckstyle = this.ruleLoader.loadDisabled(CHECKSTYLE);
        String disabledSevntu = this.ruleLoader.loadDisabled(SEVNTU);
        return String.format(readmeTemplate, this.indexBuilder.build(), enabledCheckstyle, enabledSevntu, disabledCheckstyle, disabledSevntu);
    }

    public ReadmeBuilder(ReadmeIndexBuilder indexBuilder, RuleLoader ruleLoader) {
        this.indexBuilder = indexBuilder;
        this.ruleLoader = ruleLoader;
    }
}

