/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.kemitix.checkstyle.ruleset.builder.ReadmeFragmentNotFoundException;
import net.kemitix.checkstyle.ruleset.builder.Rule;
import net.kemitix.checkstyle.ruleset.builder.RuleReadmeLoader;
import net.kemitix.checkstyle.ruleset.builder.TemplateProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class DefaultRuleReadmeLoader
implements RuleReadmeLoader {
    private static final Logger log = LoggerFactory.getLogger(DefaultRuleReadmeLoader.class);
    private final TemplateProperties templateProperties;

    @Override
    public Stream<String> load(Rule rule) {
        if (rule.isEnabled()) {
            Path resolve = this.templateProperties.getReadmeFragments().resolve(rule.getName() + ".md");
            log.info("Loading fragment: {}", (Object)resolve);
            try {
                return Stream.concat(Stream.of(this.formatRuleHeader(rule)), Files.lines(resolve));
            }
            catch (IOException e) {
                throw new ReadmeFragmentNotFoundException(rule.getName(), e);
            }
        }
        return Stream.of(this.formatRuleHeader(rule), "", rule.getReason());
    }

    private String formatRuleHeader(Rule rule) {
        return String.format("#### [%s](%s)", rule.getName(), rule.getUri());
    }

    public DefaultRuleReadmeLoader(TemplateProperties templateProperties) {
        this.templateProperties = templateProperties;
    }
}

