/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kemitix.checkstyle.ruleset.builder.CheckstyleClassNotFoundException;
import net.kemitix.checkstyle.ruleset.builder.Rule;
import net.kemitix.checkstyle.ruleset.builder.RuleClassLocator;
import net.kemitix.checkstyle.ruleset.builder.RuleSource;
import net.kemitix.checkstyle.ruleset.builder.SourcesProperties;
import org.springframework.stereotype.Service;

@Service
public class DefaultRuleClassLocator
implements RuleClassLocator {
    private final Map<RuleSource, List<String>> checkClasses;
    private final SourcesProperties sourcesProperties;

    public DefaultRuleClassLocator(Map<RuleSource, List<String>> checkClasses, SourcesProperties sourcesProperties) {
        this.checkClasses = checkClasses;
        this.sourcesProperties = sourcesProperties;
    }

    @Override
    public final String apply(Rule rule) {
        return this.getCanonicalClassName(rule.getSource(), rule.getName());
    }

    private String getCanonicalClassName(String sourceName, String name) {
        Objects.requireNonNull(this.checkClasses, "init() method not called");
        return (String)this.sourcesProperties.findSource(sourceName.toLowerCase(Locale.ENGLISH)).map(this.checkClasses::get).flatMap(classes -> classes.stream().sorted().filter(className -> this.byRuleName((String)className, name)).findFirst()).orElseThrow(() -> new CheckstyleClassNotFoundException(name));
    }

    private boolean byRuleName(String classname, String name) {
        String classNameWithDelimiter = "." + name;
        return classname.endsWith(classNameWithDelimiter) || classname.endsWith(classNameWithDelimiter + "Check");
    }
}

