/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kemitix.checkstyle.ruleset.builder.ReadmeIndexBuilder;
import net.kemitix.checkstyle.ruleset.builder.Rule;
import net.kemitix.checkstyle.ruleset.builder.RuleLevel;
import net.kemitix.checkstyle.ruleset.builder.RulesProperties;
import org.springframework.stereotype.Component;

@Component
public class DefaultReadmeIndexBuilder
implements ReadmeIndexBuilder {
    private static final String NEWLINE = "\n";
    private static final Locale LOCALE = Locale.ENGLISH;
    private final RulesProperties rulesProperties;

    @Override
    public final String build() {
        return this.rulesProperties.getRules().stream().sorted(Rule::sortByName).map(this::formatRuleRow).collect(Collectors.joining(NEWLINE));
    }

    private String getLowerCaseRuleName(Rule rule) {
        return rule.getName().toLowerCase(LOCALE);
    }

    private String formatRuleRow(Rule rule) {
        return String.format("%s|%s|%s|%s|%s", this.link(rule), this.level(rule), this.source(rule), this.enabled(rule), this.suppressible(rule));
    }

    private String suppressible(Rule rule) {
        if (rule.isInsuppressible()) {
            return "No";
        }
        return "";
    }

    private String enabled(Rule rule) {
        if (rule.isEnabled()) {
            return "Yes";
        }
        return "";
    }

    private String source(Rule rule) {
        return rule.getSource().toString().toLowerCase(LOCALE);
    }

    private String link(Rule rule) {
        return String.format("[%s](#%s)", rule.getName(), this.getLowerCaseRuleName(rule));
    }

    private String level(Rule rule) {
        return Optional.ofNullable(rule.getLevel()).orElse(RuleLevel.UNSPECIFIED).toString().toLowerCase(LOCALE);
    }

    public DefaultReadmeIndexBuilder(RulesProperties rulesProperties) {
        this.rulesProperties = rulesProperties;
    }
}

