/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.List;
import java.util.stream.Collectors;
import net.kemitix.checkstyle.ruleset.builder.PackageScanner;
import net.kemitix.checkstyle.ruleset.builder.RuleSource;
import org.springframework.stereotype.Service;

@Service
public class ClassGraphPackageScanner
implements PackageScanner {
    private final ClassGraph classGraph = new ClassGraph();

    @Override
    public final List<String> apply(RuleSource ruleSource) {
        String basePackage = ruleSource.getBasePackage();
        try (ScanResult scanResult = ClassGraphPackageScanner.scanPackage(this.classGraph, basePackage);){
            List<String> list = scanResult.getAllStandardClasses().getNames().stream().filter(packageName -> packageName.startsWith(basePackage)).collect(Collectors.toList());
            return list;
        }
    }

    private static ScanResult scanPackage(ClassGraph classGraph, String basePackage) {
        return classGraph.whitelistPackages(new String[]{basePackage}).scan();
    }
}

