/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import net.kemitix.checkstyle.ruleset.builder.CheckstyleWriterException;
import net.kemitix.checkstyle.ruleset.builder.OutputProperties;
import net.kemitix.checkstyle.ruleset.builder.Rule;
import net.kemitix.checkstyle.ruleset.builder.RuleClassLocator;
import net.kemitix.checkstyle.ruleset.builder.RuleLevel;
import net.kemitix.checkstyle.ruleset.builder.RuleParent;
import net.kemitix.checkstyle.ruleset.builder.RuleSource;
import net.kemitix.checkstyle.ruleset.builder.RulesProperties;
import net.kemitix.checkstyle.ruleset.builder.SourcesProperties;
import net.kemitix.checkstyle.ruleset.builder.TemplateNotFoundException;
import net.kemitix.checkstyle.ruleset.builder.TemplateProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
class CheckstyleWriter
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(CheckstyleWriter.class);
    private final OutputProperties outputProperties;
    private final TemplateProperties templateProperties;
    private final RulesProperties rulesProperties;
    private final RuleClassLocator ruleClassLocator;
    private final SourcesProperties sourcesProperties;
    private final Set<String> enabledSourceNames = new HashSet<String>();

    @PostConstruct
    public void init() {
        this.enabledSourceNames.addAll(this.sourcesProperties.getSources().stream().filter(RuleSource::isEnabled).map(RuleSource::getName).collect(Collectors.toSet()));
    }

    private static Predicate<RuleLevel> excludeUnspecifiedRuleLevel() {
        return level -> !level.equals((Object)RuleLevel.UNSPECIFIED);
    }

    private static void writeRuleset(Path filePath, String content) throws IOException {
        Files.write(filePath, Arrays.asList(content.split(System.lineSeparator())), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String ruleset(String checkerRules, String treeWalkerRules, String template) {
        return String.format(template, checkerRules, treeWalkerRules);
    }

    private static boolean fileExists(File file) {
        return file.exists();
    }

    private static void writeCheckstyleFileWithException(Path outputPath, String checkerRules, String treeWalkerRules, Path template) throws IOException {
        if (!CheckstyleWriter.fileExists(template.toFile())) {
            throw new TemplateNotFoundException(template);
        }
        log.info("Writing ruleset: {}", (Object)outputPath);
        String xmlTemplate = new String(Files.readAllBytes(template), StandardCharsets.UTF_8);
        CheckstyleWriter.writeRuleset(outputPath, CheckstyleWriter.ruleset(checkerRules, treeWalkerRules, xmlTemplate));
    }

    public void run(String ... args) {
        Stream.of(RuleLevel.values()).filter(CheckstyleWriter.excludeUnspecifiedRuleLevel()).forEach(this::writeCheckstyleFile);
    }

    private void writeCheckstyleFile(RuleLevel ruleLevel) {
        Path outputPath = this.outputPath(ruleLevel);
        String checkerRules = this.enabledRules(ruleLevel, RuleParent.CHECKER);
        String treeWalkerRules = this.enabledRules(ruleLevel, RuleParent.TREEWALKER);
        Path template = this.templateProperties.getCheckstyleXml();
        try {
            CheckstyleWriter.writeCheckstyleFileWithException(outputPath, checkerRules, treeWalkerRules, template);
        }
        catch (IOException e) {
            throw new CheckstyleWriterException(e);
        }
    }

    private Path outputPath(RuleLevel ruleLevel) {
        return this.outputProperties.getDirectory().resolve(this.outputProperties.getRulesetFiles().get((Object)ruleLevel));
    }

    private String enabledRules(RuleLevel ruleLevel, RuleParent ruleParent) {
        return this.rulesProperties.getRules().stream().filter(Rule::isEnabled).filter(rule -> this.enabledSourceNames.contains(rule.getSource())).filter(Rule.hasParent(ruleParent)).filter(Rule.isIncludedInLevel(ruleLevel)).map(rule -> Rule.asModule((String)this.ruleClassLocator.apply(rule), rule)).collect(Collectors.joining(System.lineSeparator()));
    }

    public CheckstyleWriter(OutputProperties outputProperties, TemplateProperties templateProperties, RulesProperties rulesProperties, RuleClassLocator ruleClassLocator, SourcesProperties sourcesProperties) {
        this.outputProperties = outputProperties;
        this.templateProperties = templateProperties;
        this.rulesProperties = rulesProperties;
        this.ruleClassLocator = ruleClassLocator;
        this.sourcesProperties = sourcesProperties;
    }
}

