/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.checkstyle.ruleset.builder;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kemitix.checkstyle.ruleset.builder.PackageScanner;
import net.kemitix.checkstyle.ruleset.builder.RuleSource;
import net.kemitix.checkstyle.ruleset.builder.SourcesProperties;
import net.kemitix.files.FileReaderWriter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BuilderConfiguration {
    private final SourcesProperties sourcesProperties;

    @Bean
    public Map<RuleSource, List<String>> checkClasses(PackageScanner packageScanner) {
        return this.sourcesProperties.getSources().stream().map(source -> BuilderConfiguration.entry(source, (List)packageScanner.apply(source))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <K, V> AbstractMap.SimpleEntry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    @Bean
    public FileReaderWriter fileReaderWriter() {
        return new FileReaderWriter();
    }

    public BuilderConfiguration(SourcesProperties sourcesProperties) {
        this.sourcesProperties = sourcesProperties;
    }
}

