package net.kcqy.util.web;


import com.alibaba.fastjson2.JSONObject;

public class JsonResult extends JSONObject {
    public static final String DATA_KEY = "data";
    public static final String SUCCESS_KEY = "success";
    public static final String FAIL_KEY = "fail";
    public static final String EXCEPTION_KEY = "exception";

    public static JsonResult createWithFail() {
        JsonResult result = new JsonResult();
        result.setFail();

        return result;
    }

    public static JsonResult createWithSuccess() {
        JsonResult result = new JsonResult();
        result.setSuccess();

        return result;
    }

    public static JsonResult createWithException() {
        JsonResult result = new JsonResult();
        result.setException();

        return result;
    }

    public boolean isSuccess() {
        return get("success") != null;
    }

    public boolean isFail() {
        return get("fail") != null;
    }

    public boolean isException() {
        return get("exception") != null;
    }

    public Object getData() {
        Object d = get("data");
        return d == null ? new JSONObject() : d;
    }

    public void setSuccess() {
        remove("exception");
        remove("fail");
        put("success", Boolean.valueOf(true));
        put("code", 200);
    }

    public void setFail() {
        remove("success");
        remove("exception");
        put("fail", Boolean.valueOf(true));
        put("code", 500);
    }

    public void setException() {
        remove("success");
        remove("fail");
        put("exception", Boolean.valueOf(true));
        put("code", 500);
    }

    public void setCode(int code) {
        put("code", 500);
    }

    public void setMsg(String msg) {
        put("msg", msg);
    }

    public void set(String key , Object value) {
        put(key, value);
    }

    public void setData(Object data) {
        put("data", data);
    }
}