/*
 * Decompiled with CFR 0.152.
 */
package net.kcqy.util.web;

import com.alibaba.fastjson2.JSONObject;

public class JsonResult
extends JSONObject {
    public static final String DATA_KEY = "data";
    public static final String SUCCESS_KEY = "success";
    public static final String FAIL_KEY = "fail";
    public static final String EXCEPTION_KEY = "exception";

    public static JsonResult createWithFail() {
        JsonResult result = new JsonResult();
        result.setFail();
        return result;
    }

    public static JsonResult createWithSuccess() {
        JsonResult result = new JsonResult();
        result.setSuccess();
        return result;
    }

    public static JsonResult createWithException() {
        JsonResult result = new JsonResult();
        result.setException();
        return result;
    }

    public boolean isSuccess() {
        return this.get(SUCCESS_KEY) != null;
    }

    public boolean isFail() {
        return this.get(FAIL_KEY) != null;
    }

    public boolean isException() {
        return this.get(EXCEPTION_KEY) != null;
    }

    public Object getData() {
        Object d = this.get(DATA_KEY);
        return d == null ? new JSONObject() : d;
    }

    public void setSuccess() {
        this.remove(EXCEPTION_KEY);
        this.remove(FAIL_KEY);
        this.put(SUCCESS_KEY, true);
        this.put("code", 200);
    }

    public void setFail() {
        this.remove(SUCCESS_KEY);
        this.remove(EXCEPTION_KEY);
        this.put(FAIL_KEY, true);
        this.put("code", 500);
    }

    public void setException() {
        this.remove(SUCCESS_KEY);
        this.remove(FAIL_KEY);
        this.put(EXCEPTION_KEY, true);
        this.put("code", 500);
    }

    public void setCode(int code) {
        this.put("code", 500);
    }

    public void setMsg(String msg) {
        this.put("msg", msg);
    }

    public void set(String key, Object value) {
        this.put(key, value);
    }

    public void setData(Object data) {
        this.put(DATA_KEY, data);
    }
}

