package net.kcqy.util.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

/**
 * Cookie辅助类
 * @author 游陈其
 *
 */
public class CookieUtils {
	
	public static final int A_YEAR = 60 * 60 * 24 * 365;

	/**
	 * 设置cookie
	 * 
	 * @param response
	 * @param name
	 *            cookie名字
	 * @param value
	 *            cookie值
	 * @param maxAge
	 *            cookie生命周期 以秒为单位
	 * @throws UnsupportedEncodingException
	 */

	public static void addCookie(HttpServletResponse response, String name,
			String value, int maxAge) throws UnsupportedEncodingException {
		value = URLEncoder.encode(value, "UTF-8");
		Cookie cookie = new Cookie(name, value);
		cookie.setPath("/");
		if (maxAge > 0)
			cookie.setMaxAge(maxAge);
		response.addCookie(cookie);
	}
	
	public static void addCookie(HttpServletResponse response, String name,
			String value) throws UnsupportedEncodingException {
		value = URLEncoder.encode(value, "UTF-8");
		Cookie cookie = new Cookie(name, value);
		cookie.setPath("/");
		response.addCookie(cookie);
	}
	
	public static void removeCookie(HttpServletResponse response, String name) throws UnsupportedEncodingException {
		Cookie cookie = new Cookie(name, "");
		cookie.setPath("/");
		cookie.setMaxAge(0);
		response.addCookie(cookie);
	}

	/**
	 * 根据名字获取cookie
	 * 
	 * @param request
	 * @param name
	 *            cookie名字
	 * @return
	 * @throws UnsupportedEncodingException
	 */

	public static Cookie getCookieByName(HttpServletRequest request, String name) throws UnsupportedEncodingException {
		Map<String, Cookie> cookieMap = ReadCookieMap(request);
		if (cookieMap.containsKey(name)) {
			Cookie cookie = cookieMap.get(name);
			cookie.setValue(URLDecoder.decode(cookie.getValue(), "UTF-8"));
			return cookie;
		} else {
			return null;
		}
	}
	
	

	/**
	 * 将cookie封装到Map里面
	 * 
	 * @param request
	 * @return
	 */

	private static Map<String, Cookie> ReadCookieMap(HttpServletRequest request) {
		Map<String, Cookie> cookieMap = new HashMap<String, Cookie>();
		Cookie[] cookies = request.getCookies();
		if (null != cookies) {
			for (Cookie cookie : cookies) {
				cookieMap.put(cookie.getName(), cookie);
			}
		}
		return cookieMap;
	}
	
	
}
