package net.kcqy.entity;


import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson2.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.experimental.FieldNameConstants;
import java.util.Date;

@Data
@Accessors(chain = true)
@FieldNameConstants
public abstract class AbstractEntityWithUUID {

    @TableId(type = IdType.ASSIGN_UUID)
    protected String id;

    @TableField(value = "is_deleted")
    @TableLogic(value = "0", delval = "1")
    @JSONField(serialize = false)
    protected Boolean deleted = false;

    @Version
    @JSONField(serialize = false)
    protected Integer version;

    @TableField(fill = FieldFill.INSERT)
    @JSONField(serialize = false)
    protected Date createTime = DateTime.now();

}
