/*
 * Decompiled with CFR 0.152.
 */
package net.kawinski.logging;

import org.slf4j.MDC;

public final class NkTraceIndent {
    public static final String MDC_INDENT_KEY = "indent";
    public static final int SPACES_PER_INDENT = 3;
    private static final ThreadLocal<Integer> threadIndent = ThreadLocal.withInitial(() -> 0);

    private NkTraceIndent() {
    }

    public static void reset() {
        threadIndent.remove();
        NkTraceIndent.updateMDC();
    }

    public static void increment() {
        threadIndent.set(threadIndent.get() + 1);
        NkTraceIndent.updateMDC();
    }

    public static void decrement() {
        threadIndent.set(threadIndent.get() - 1);
        NkTraceIndent.updateMDC();
    }

    private static void updateMDC() {
        MDC.put((String)MDC_INDENT_KEY, (String)NkTraceIndent.getCurrentIndent());
    }

    public static int getIndentCount() {
        return threadIndent.get();
    }

    public static String getIndent(int indentCount) {
        int spaces = indentCount * 3;
        StringBuilder indentBuilder = new StringBuilder(spaces);
        for (int i = 0; i < spaces; ++i) {
            indentBuilder.append(" ");
        }
        return indentBuilder.toString();
    }

    public static String getCurrentIndent() {
        return NkTraceIndent.getIndent(NkTraceIndent.getIndentCount());
    }
}

