/*
 * Decompiled with CFR 0.152.
 */
package net.kawinski.logging;

import net.kawinski.logging.CallerInfo;
import net.kawinski.logging.LoggingUtils;
import net.kawinski.logging.NkTraceIndent;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.event.Level;
import org.slf4j.spi.LocationAwareLogger;

public class NkTrace
implements AutoCloseable {
    public static boolean useDefaultFormatting = Boolean.parseBoolean(System.getProperty("NKTRACE_USE_DEFAULT_FORMATTING", "true"));
    public static final String DEFAULT_FQCN = NkTrace.class.getName();
    public static final String MARKER_TRACE_ENTRY_NAME = "NkTraceEntry";
    public static final String MARKER_TRACE_EXIT_NAME = "NkTraceExit";
    public static final Marker MARKER_TRACE_ENTRY = MarkerFactory.getMarker((String)"NkTraceEntry");
    public static final Marker MARKER_TRACE_EXIT = MarkerFactory.getMarker((String)"NkTraceExit");
    private final String fqcn;
    private final Logger logger;
    private final Level level;
    private final boolean canLog;
    private final CallerInfo caller;
    private Object returning = null;
    private String exitMsg = "";
    private Object[] exitMsgArgs = new Object[0];

    public NkTrace(Logger logger, Level level, String format, Object ... formatArgs) {
        this(DEFAULT_FQCN, logger, level, format, formatArgs);
    }

    public NkTrace(String fqcn, Logger logger, Level level, String format, Object ... formatArgs) {
        this.fqcn = fqcn;
        this.logger = logger;
        this.level = level;
        this.canLog = LoggingUtils.canLog(logger, level);
        if (!this.canLog) {
            this.caller = CallerInfo.UNKNOWN;
            return;
        }
        this.caller = CallerInfo.getCaller(fqcn);
        this.doEntryLog(format, formatArgs);
        NkTraceIndent.increment();
    }

    @Override
    public void close() {
        if (!this.canLog) {
            return;
        }
        NkTraceIndent.decrement();
        this.doExitLog();
    }

    public void setExitMsg(Object exitMsg) {
        this.setExitMsg("{}", exitMsg);
    }

    public void setExitMsg(String format, Object ... formatArgs) {
        this.returning(this.returning, format, formatArgs);
    }

    public <T> T returning(T result) {
        return this.returning(result, this.exitMsg, this.exitMsgArgs);
    }

    public <T> T returning(T result, String format, Object ... formatArgs) {
        this.returning = result;
        this.exitMsg = format;
        this.exitMsgArgs = (Object[])formatArgs.clone();
        return result;
    }

    private static void doLog(String fqcn, Logger loggerArg, Level level, Marker marker, String format, Object[] formatArgs) {
        LocationAwareLogger logger = (LocationAwareLogger)loggerArg;
        logger.log(marker, fqcn, level.toInt(), format, formatArgs, null);
    }

    private void doEntryLog(String format, Object[] formatArgs) {
        String finalFormat = format;
        if (useDefaultFormatting) {
            finalFormat = ">> " + this.caller.shortClassName + "." + this.caller.methodName + ":" + this.caller.lineNumber + (format.isEmpty() ? "" : " " + format);
        }
        NkTrace.doLog(this.fqcn, this.logger, this.level, MARKER_TRACE_ENTRY, finalFormat, formatArgs);
    }

    private void doExitLog() {
        StringBuilder finalExitMsg = new StringBuilder();
        Object[] finalExitMsgArgs = this.exitMsgArgs;
        if (useDefaultFormatting) {
            finalExitMsg.append("<< ");
            finalExitMsg.append(this.caller.shortClassName);
            finalExitMsg.append(".");
            finalExitMsg.append(this.caller.methodName);
            finalExitMsg.append(":");
            finalExitMsg.append(this.caller.lineNumber);
        }
        if (this.returning != null) {
            if (finalExitMsg.length() > 0) {
                finalExitMsg.append(" ");
            }
            finalExitMsg.append("returning({})");
            finalExitMsgArgs = LoggingUtils.prepend(this.exitMsgArgs, this.returning);
        }
        if (this.exitMsg != null && !this.exitMsg.isEmpty()) {
            if (finalExitMsg.length() > 0) {
                finalExitMsg.append(" ");
            }
            finalExitMsg.append(this.exitMsg);
        }
        NkTrace.doLog(this.fqcn, this.logger, this.level, MARKER_TRACE_EXIT, finalExitMsg.toString(), finalExitMsgArgs);
    }

    public static NkTrace trace(Logger logger) {
        return new NkTrace(logger, Level.TRACE, "", new Object[0]);
    }

    public static NkTrace trace(Logger logger, String format, Object ... formatArgs) {
        return new NkTrace(logger, Level.TRACE, format, formatArgs);
    }

    public static NkTrace debug(Logger logger) {
        return new NkTrace(logger, Level.DEBUG, "", new Object[0]);
    }

    public static NkTrace debug(Logger logger, String format, Object ... formatArgs) {
        return new NkTrace(logger, Level.DEBUG, format, formatArgs);
    }

    public static NkTrace info(Logger logger) {
        return new NkTrace(logger, Level.INFO, "", new Object[0]);
    }

    public static NkTrace info(Logger logger, String format, Object ... formatArgs) {
        return new NkTrace(logger, Level.INFO, format, formatArgs);
    }
}

