/*
 * Decompiled with CFR 0.152.
 */
package net.kawinski.logging;

import org.slf4j.Logger;
import org.slf4j.event.Level;

public final class LoggingUtils {
    private LoggingUtils() {
    }

    public static boolean canLog(Logger logger, Level level) {
        switch (level) {
            case ERROR: {
                return logger.isErrorEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case TRACE: {
                return logger.isTraceEnabled();
            }
        }
        return false;
    }

    public static Object[] prepend(Object[] array, Object element) {
        Object[] newArray = new Object[array.length + 1];
        newArray[0] = element;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }
}

