/*
 * Decompiled with CFR 0.152.
 */
package net.kawinski.logging;

public final class CallerInfo {
    public static final CallerInfo UNKNOWN = new CallerInfo("unknown", "unknown", 0);
    public final String fullClassName;
    public final String shortClassName;
    public final String methodName;
    public final int lineNumber;

    private CallerInfo(StackTraceElement callerSte) {
        this(callerSte.getClassName(), callerSte.getMethodName(), callerSte.getLineNumber());
    }

    private CallerInfo(String fullClassName, String methodName, int lineNumber) {
        this.fullClassName = fullClassName;
        String[] classNameArr = fullClassName.split("\\.");
        this.shortClassName = classNameArr[classNameArr.length - 1];
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public String toString() {
        return this.shortClassName + "." + this.methodName + ":" + this.lineNumber;
    }

    public static CallerInfo getCaller() {
        int callerStackTraceIndex = 3;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement stack = stackTrace[3];
        return new CallerInfo(stack);
    }

    public static CallerInfo getCaller(String fqcn) {
        int callerStackTraceIndex = 3;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 3; i < stackTrace.length; ++i) {
            StackTraceElement resultStack;
            StackTraceElement stack = stackTrace[i];
            if (!fqcn.equals(stack.getClassName()) || fqcn.equals((resultStack = stackTrace[i + 1]).getClassName())) continue;
            return new CallerInfo(resultStack);
        }
        return UNKNOWN;
    }
}

