/*
 * Decompiled with CFR 0.152.
 */
package net.justmachinery.shade.state;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.ThreadContextElement;
import net.justmachinery.shade.state.Atom;
import net.justmachinery.shade.state.BatchChangesUntilSuspend;
import net.justmachinery.shade.state.ChangeBatch;
import net.justmachinery.shade.state.ChangeBatchChangePolicy;
import net.justmachinery.shade.state.ComputedValue;
import net.justmachinery.shade.state.DirtyNodeData;
import net.justmachinery.shade.state.ObserverCountAndList;
import net.justmachinery.shade.state.ReactiveObserver;
import net.justmachinery.shade.state.StartChangeBatchResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a)\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\"\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u001a\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"changeBatch", "Ljava/lang/ThreadLocal;", "Lnet/justmachinery/shade/state/ChangeBatch;", "getChangeBatch", "()Ljava/lang/ThreadLocal;", "runChangeBatch", "T", "changePolicy", "Lnet/justmachinery/shade/state/ChangeBatchChangePolicy;", "block", "Lkotlin/Function0;", "(Lnet/justmachinery/shade/state/ChangeBatchChangePolicy;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "startChangeBatch", "Lnet/justmachinery/shade/state/StartChangeBatchResult;", "findAllPotentiallyDirtyNodes", "", "Lnet/justmachinery/shade/state/ReactiveObserver;", "Lnet/justmachinery/shade/state/DirtyNodeData;", "changed", "Lkotlin/sequences/Sequence;", "Lnet/justmachinery/shade/state/Atom;", "topologicalSort", "Lnet/justmachinery/shade/state/ObserverCountAndList;", "dirty", "batchChangesUntilSuspend", "Lkotlinx/coroutines/ThreadContextElement;", "getBatchChangesUntilSuspend", "()Lkotlinx/coroutines/ThreadContextElement;", "shade"})
@SourceDebugExtension(value={"SMAP\nChangeBatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeBatch.kt\nnet/justmachinery/shade/state/ChangeBatchKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1869#2,2:195\n1869#2:197\n1870#2:199\n1#3:198\n*S KotlinDebug\n*F\n+ 1 ChangeBatch.kt\nnet/justmachinery/shade/state/ChangeBatchKt\n*L\n126#1:195,2\n159#1:197\n159#1:199\n*E\n"})
public final class ChangeBatchKt {
    @NotNull
    private static final ThreadLocal<ChangeBatch> changeBatch = new ThreadLocal();
    @NotNull
    private static final ThreadContextElement<?> batchChangesUntilSuspend = new BatchChangesUntilSuspend();

    @NotNull
    public static final ThreadLocal<ChangeBatch> getChangeBatch() {
        return changeBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T runChangeBatch(@NotNull ChangeBatchChangePolicy changePolicy, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)changePolicy), (String)"changePolicy");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Closeable closeable = ChangeBatchKt.startChangeBatch(changePolicy);
        Throwable throwable = null;
        try {
            StartChangeBatchResult it = (StartChangeBatchResult)closeable;
            boolean bl = false;
            Object object = block.invoke();
            return (T)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final StartChangeBatchResult startChangeBatch(@NotNull ChangeBatchChangePolicy changePolicy) {
        StartChangeBatchResult startChangeBatchResult;
        Intrinsics.checkNotNullParameter((Object)((Object)changePolicy), (String)"changePolicy");
        ChangeBatch existing = changeBatch.get();
        if (existing != null) {
            ChangeBatchChangePolicy existingChangePolicy = existing.getChangePolicy();
            if (changePolicy == ChangeBatchChangePolicy.ALLOWED && existingChangePolicy == ChangeBatchChangePolicy.DISALLOWED) {
                throw new IllegalStateException("Can't make changes inside a render block!");
            }
            existing.setChangePolicy(changePolicy);
            startChangeBatchResult = new StartChangeBatchResult.Existing(existing, existingChangePolicy);
        } else {
            Set set = Sets.newIdentityHashSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newIdentityHashSet(...)");
            ChangeBatch newBatch = new ChangeBatch(changePolicy, set);
            changeBatch.set(newBatch);
            startChangeBatchResult = new StartChangeBatchResult.New(newBatch);
        }
        return startChangeBatchResult;
    }

    private static final Map<ReactiveObserver, DirtyNodeData> findAllPotentiallyDirtyNodes(Sequence<Atom> changed) {
        IdentityHashMap<ReactiveObserver, DirtyNodeData> dirtied = new IdentityHashMap<ReactiveObserver, DirtyNodeData>();
        boolean first = false;
        first = true;
        List unvisited = SequencesKt.toList((Sequence)SequencesKt.flatMap(changed, ChangeBatchKt::findAllPotentiallyDirtyNodes$lambda$1));
        while (true) {
            List nextUnvisited = new ArrayList();
            Iterable $this$forEach$iv = unvisited;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReactiveObserver observer = (ReactiveObserver)element$iv;
                boolean bl = false;
                if (dirtied.put(observer, new DirtyNodeData(false, first)) != null || !(observer instanceof ComputedValue)) continue;
                nextUnvisited.addAll((Collection)((ComputedValue)observer).getObservers());
            }
            if (nextUnvisited.isEmpty()) break;
            unvisited = nextUnvisited;
            first = false;
        }
        return dirtied;
    }

    private static final ObserverCountAndList topologicalSort(Map<ReactiveObserver, DirtyNodeData> dirty) {
        ArrayList<ReactiveObserver> sorted = new ArrayList<ReactiveObserver>();
        IdentityHashMap<ReactiveObserver, Integer> staleDependencyCount = new IdentityHashMap<ReactiveObserver, Integer>();
        while (!dirty.isEmpty()) {
            Map.Entry first = (Map.Entry)CollectionsKt.first((Iterable)dirty.entrySet());
            ChangeBatchKt.topologicalSort$visit(dirty, sorted, staleDependencyCount, (ReactiveObserver)first.getKey(), (DirtyNodeData)first.getValue());
        }
        List list = CollectionsKt.asReversedMutable((List)sorted);
        return new ObserverCountAndList(staleDependencyCount, list);
    }

    @NotNull
    public static final ThreadContextElement<?> getBatchChangesUntilSuspend() {
        return batchChangesUntilSuspend;
    }

    private static final Sequence findAllPotentiallyDirtyNodes$lambda$1(Atom it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence((Iterable)it.getObservers$shade());
    }

    private static final Integer topologicalSort$visit$lambda$6$lambda$4(ReactiveObserver reactiveObserver, Integer value) {
        Integer n = value;
        return (n != null ? n : 0) + 1;
    }

    private static final Integer topologicalSort$visit$lambda$6$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer topologicalSort$visit$lambda$7(DirtyNodeData $data, ReactiveObserver reactiveObserver, Integer value) {
        Integer n = value;
        return (n != null ? n : 0) + ($data.isRootDirty() ? 1 : 0);
    }

    private static final Integer topologicalSort$visit$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final void topologicalSort$visit(Map<ReactiveObserver, DirtyNodeData> $dirty, ArrayList<ReactiveObserver> sorted, IdentityHashMap<ReactiveObserver, Integer> staleDependencyCount, ReactiveObserver key, DirtyNodeData data) {
        if (data.isTemporaryMarked()) {
            throw new IllegalStateException("Circular loop detected involving " + key);
        }
        data.setTemporaryMarked(true);
        if (key instanceof ComputedValue) {
            Iterable $this$forEach$iv = ((ComputedValue)key).getObservers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReactiveObserver obs = (ReactiveObserver)element$iv;
                boolean bl = false;
                if ($dirty.get(obs) != null) {
                    DirtyNodeData it;
                    boolean bl2 = false;
                    ChangeBatchKt.topologicalSort$visit($dirty, sorted, staleDependencyCount, obs, it);
                }
                staleDependencyCount.compute(obs, (arg_0, arg_1) -> ChangeBatchKt.topologicalSort$visit$lambda$6$lambda$5(ChangeBatchKt::topologicalSort$visit$lambda$6$lambda$4, arg_0, arg_1));
            }
        }
        $dirty.remove(key);
        sorted.add(key);
        staleDependencyCount.compute(key, (arg_0, arg_1) -> ChangeBatchKt.topologicalSort$visit$lambda$8((arg_0, arg_1) -> ChangeBatchKt.topologicalSort$visit$lambda$7(data, arg_0, arg_1), arg_0, arg_1));
    }

    public static final /* synthetic */ Map access$findAllPotentiallyDirtyNodes(Sequence changed) {
        return ChangeBatchKt.findAllPotentiallyDirtyNodes((Sequence<Atom>)changed);
    }

    public static final /* synthetic */ ObserverCountAndList access$topologicalSort(Map dirty) {
        return ChangeBatchKt.topologicalSort(dirty);
    }
}

