/*
 * Decompiled with CFR 0.152.
 */
package net.justmachinery.shade.routing.annotation.processor;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.ksp.KsClassDeclarationsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.justmachinery.shade.routing.annotation.NotFound;
import net.justmachinery.shade.routing.annotation.QueryParam;
import net.justmachinery.shade.routing.annotation.RoutedPage;
import net.justmachinery.shade.routing.annotation.RoutedPath;
import net.justmachinery.shade.routing.annotation.processor.AnnotationRoutingEmitter;
import net.justmachinery.shade.routing.annotation.processor.GenerateRouting;
import net.justmachinery.shade.routing.annotation.processor.NotFoundHandler;
import net.justmachinery.shade.routing.annotation.processor.PageData;
import net.justmachinery.shade.routing.annotation.processor.PathRouteData;
import net.justmachinery.shade.routing.annotation.processor.QueryParameterData;
import net.justmachinery.shade.routing.annotation.processor.RouteData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/justmachinery/shade/routing/annotation/processor/AnnotationRoutingProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "<init>", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "WithResolver", "shade"})
public final class AnnotationRoutingProcessor
implements SymbolProcessor {
    @NotNull
    private final SymbolProcessorEnvironment environment;

    public AnnotationRoutingProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        new WithResolver(resolver).process();
        return CollectionsKt.emptyList();
    }

    public void finish() {
        super.finish();
    }

    public void onError() {
        super.onError();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u001f"}, d2={"Lnet/justmachinery/shade/routing/annotation/processor/AnnotationRoutingProcessor$WithResolver;", "", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "<init>", "(Lnet/justmachinery/shade/routing/annotation/processor/AnnotationRoutingProcessor;Lcom/google/devtools/ksp/processing/Resolver;)V", "routedPath", "Lcom/google/devtools/ksp/symbol/KSType;", "getRoutedPath", "()Lcom/google/devtools/ksp/symbol/KSType;", "routedPage", "getRoutedPage", "queryParam", "getQueryParam", "notFound", "getNotFound", "process", "", "buildRoutingData", "Lnet/justmachinery/shade/routing/annotation/processor/RouteData;", "element", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "extractQueryParameter", "Lcom/squareup/kotlinpoet/TypeName;", "type", "reportNode", "Lcom/google/devtools/ksp/symbol/KSNode;", "extractQueryParameters", "", "Lnet/justmachinery/shade/routing/annotation/processor/QueryParameterData;", "target", "shade"})
    @SourceDebugExtension(value={"SMAP\nAnnotationRoutingProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationRoutingProcessor.kt\nnet/justmachinery/shade/routing/annotation/processor/AnnotationRoutingProcessor$WithResolver\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,147:1\n1321#2,2:148\n183#2,2:150\n*S KotlinDebug\n*F\n+ 1 AnnotationRoutingProcessor.kt\nnet/justmachinery/shade/routing/annotation/processor/AnnotationRoutingProcessor$WithResolver\n*L\n45#1:148,2\n110#1:150,2\n*E\n"})
    public final class WithResolver {
        @NotNull
        private final Resolver resolver;
        @NotNull
        private final KSType routedPath;
        @NotNull
        private final KSType routedPage;
        @NotNull
        private final KSType queryParam;
        @NotNull
        private final KSType notFound;

        public WithResolver(Resolver resolver) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            this.resolver = resolver;
            String string = Reflection.getOrCreateKotlinClass(RoutedPath.class).getQualifiedName();
            Intrinsics.checkNotNull((Object)string);
            KSClassDeclaration kSClassDeclaration = this.resolver.getClassDeclarationByName(this.resolver.getKSNameFromString(string));
            Intrinsics.checkNotNull((Object)kSClassDeclaration);
            this.routedPath = kSClassDeclaration.asStarProjectedType();
            String string2 = Reflection.getOrCreateKotlinClass(RoutedPage.class).getQualifiedName();
            Intrinsics.checkNotNull((Object)string2);
            KSClassDeclaration kSClassDeclaration2 = this.resolver.getClassDeclarationByName(this.resolver.getKSNameFromString(string2));
            Intrinsics.checkNotNull((Object)kSClassDeclaration2);
            this.routedPage = kSClassDeclaration2.asStarProjectedType();
            String string3 = Reflection.getOrCreateKotlinClass(QueryParam.class).getQualifiedName();
            Intrinsics.checkNotNull((Object)string3);
            KSClassDeclaration kSClassDeclaration3 = this.resolver.getClassDeclarationByName(this.resolver.getKSNameFromString(string3));
            Intrinsics.checkNotNull((Object)kSClassDeclaration3);
            this.queryParam = kSClassDeclaration3.asStarProjectedType();
            String string4 = Reflection.getOrCreateKotlinClass(NotFound.class).getQualifiedName();
            Intrinsics.checkNotNull((Object)string4);
            KSClassDeclaration kSClassDeclaration4 = this.resolver.getClassDeclarationByName(this.resolver.getKSNameFromString(string4));
            Intrinsics.checkNotNull((Object)kSClassDeclaration4);
            this.notFound = kSClassDeclaration4.asStarProjectedType();
        }

        @NotNull
        public final KSType getRoutedPath() {
            return this.routedPath;
        }

        @NotNull
        public final KSType getRoutedPage() {
            return this.routedPage;
        }

        @NotNull
        public final KSType getQueryParam() {
            return this.queryParam;
        }

        @NotNull
        public final KSType getNotFound() {
            return this.notFound;
        }

        /*
         * WARNING - void declaration
         */
        public final void process() {
            void $this$forEach$iv;
            Sequence data;
            String string = GenerateRouting.class.getCanonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
            Sequence routings = SequencesKt.filterIsInstance((Sequence)Resolver.getSymbolsWithAnnotation$default((Resolver)this.resolver, (String)string, (boolean)false, (int)2, null), KSClassDeclaration.class);
            Sequence sequence = data = SequencesKt.map((Sequence)routings, arg_0 -> WithResolver.process$lambda$0(this, arg_0));
            AnnotationRoutingProcessor annotationRoutingProcessor = AnnotationRoutingProcessor.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RouteData route = (RouteData)element$iv;
                boolean bl = false;
                new AnnotationRoutingEmitter(annotationRoutingProcessor.environment, route).write();
            }
        }

        private final RouteData buildRoutingData(KSClassDeclaration element) {
            List pages = new ArrayList();
            List paths = new ArrayList();
            List queryParameters = new ArrayList();
            List notFoundHandlers = new ArrayList();
            for (KSPropertyDeclaration property : element.getAllProperties()) {
                TypeName paramType;
                KSType type = property.getType().resolve();
                if (this.routedPath.isAssignableFrom(type)) {
                    KSTypeReference kSTypeReference = ((KSTypeArgument)type.getArguments().get(0)).getType();
                    Intrinsics.checkNotNull((Object)kSTypeReference);
                    KSType subRouter = kSTypeReference.resolve();
                    if (!(subRouter.getDeclaration() instanceof KSClassDeclaration)) {
                        AnnotationRoutingProcessor.this.environment.getLogger().error("Must be a concrete class", (KSNode)property);
                        continue;
                    }
                    KSDeclaration kSDeclaration = subRouter.getDeclaration();
                    Intrinsics.checkNotNull((Object)kSDeclaration, (String)"null cannot be cast to non-null type com.google.devtools.ksp.symbol.KSClassDeclaration");
                    RouteData result = this.buildRoutingData((KSClassDeclaration)kSDeclaration);
                    paths.add(new PathRouteData(result, property.getSimpleName().asString()));
                    continue;
                }
                if (this.routedPage.isAssignableFrom(type)) {
                    KSTypeReference kSTypeReference = ((KSTypeArgument)type.getArguments().get(0)).getType();
                    Intrinsics.checkNotNull((Object)kSTypeReference);
                    KSType queryParamSpec = kSTypeReference.resolve();
                    pages.add(new PageData(property.getSimpleName().asString(), this.extractQueryParameters(queryParamSpec, (KSNode)property)));
                    continue;
                }
                if (this.notFound.isAssignableFrom(type)) {
                    notFoundHandlers.add(new NotFoundHandler(property.getSimpleName().asString()));
                    continue;
                }
                if (!this.queryParam.isAssignableFrom(type) || (paramType = this.extractQueryParameter(type, (KSNode)property)) == null) continue;
                queryParameters.add(new QueryParameterData(property.getSimpleName().asString(), paramType));
            }
            KSFile kSFile = element.getContainingFile();
            Intrinsics.checkNotNull((Object)kSFile);
            return new RouteData(kSFile, KsClassDeclarationsKt.toClassName((KSClassDeclaration)element), pages, paths, queryParameters, notFoundHandlers);
        }

        private final TypeName extractQueryParameter(KSType type, KSNode reportNode) {
            KSClassDeclaration singleArgument;
            Object v2;
            KSClassDeclaration decl;
            block4: {
                KSDeclaration kSDeclaration = type.getDeclaration();
                KSClassDeclaration kSClassDeclaration = decl = kSDeclaration instanceof KSClassDeclaration ? (KSClassDeclaration)kSDeclaration : null;
                if (decl == null) {
                    AnnotationRoutingProcessor.this.environment.getLogger().error("Must be a concrete class", reportNode);
                    return null;
                }
                Sequence $this$firstOrNull$iv = UtilsKt.getAllSuperTypes((KSClassDeclaration)decl);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KSType it = (KSType)element$iv;
                    boolean bl = false;
                    KSName kSName = it.getDeclaration().getQualifiedName();
                    if (!Intrinsics.areEqual((Object)(kSName != null ? kSName.asString() : null), (Object)Reflection.getOrCreateKotlinClass(QueryParam.class).getQualifiedName())) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            KSType superType = v2;
            if (superType == null) {
                AnnotationRoutingProcessor.this.environment.getLogger().error("Must extend only QueryParam (" + decl + ", " + superType + ")", reportNode);
                return null;
            }
            KSTypeArgument kSTypeArgument = (KSTypeArgument)CollectionsKt.singleOrNull((List)superType.getArguments());
            KSDeclaration kSDeclaration = kSTypeArgument != null && (kSTypeArgument = kSTypeArgument.getType()) != null && (kSTypeArgument = kSTypeArgument.resolve()) != null ? kSTypeArgument.getDeclaration() : null;
            KSClassDeclaration kSClassDeclaration = singleArgument = kSDeclaration instanceof KSClassDeclaration ? (KSClassDeclaration)kSDeclaration : null;
            if (singleArgument == null) {
                AnnotationRoutingProcessor.this.environment.getLogger().error("Must pass concrete type to QueryParam", reportNode);
                return null;
            }
            return (TypeName)KsClassDeclarationsKt.toClassName((KSClassDeclaration)singleArgument);
        }

        private final List<QueryParameterData> extractQueryParameters(KSType target, KSNode reportNode) {
            KSClassDeclaration decl;
            KSDeclaration kSDeclaration = target.getDeclaration();
            KSClassDeclaration kSClassDeclaration = decl = kSDeclaration instanceof KSClassDeclaration ? (KSClassDeclaration)kSDeclaration : null;
            if (decl == null) {
                AnnotationRoutingProcessor.this.environment.getLogger().error("Must be a concrete class", reportNode);
                return CollectionsKt.emptyList();
            }
            List parameters = new ArrayList();
            for (KSPropertyDeclaration property : decl.getAllProperties()) {
                TypeName param;
                KSType propertyType = property.getType().resolve();
                if (!this.queryParam.isAssignableFrom(propertyType) || (param = this.extractQueryParameter(propertyType, (KSNode)property)) == null) continue;
                parameters.add(new QueryParameterData(property.getSimpleName().asString(), param));
            }
            return parameters;
        }

        private static final RouteData process$lambda$0(WithResolver this$0, KSClassDeclaration element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this$0.buildRoutingData(element);
        }
    }
}

