/*
 * Decompiled with CFR 0.152.
 */
package net.justmachinery.shade.render;

import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.html.Tag;
import net.justmachinery.shade.render.ComponentRenderState;
import net.justmachinery.shade.render.RenderTreeChild;
import net.justmachinery.shade.render.RenderTreeLocation;
import net.justmachinery.shade.render.RenderTreeLocationFrame;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0010H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lnet/justmachinery/shade/render/RenderTreeRecorder;", "", "frameStack", "Ljava/util/Stack;", "Lnet/justmachinery/shade/render/RenderTreeLocationFrame;", "renderState", "Lnet/justmachinery/shade/render/ComponentRenderState;", "<init>", "(Ljava/util/Stack;Lnet/justmachinery/shade/render/ComponentRenderState;)V", "getFrameStack", "()Ljava/util/Stack;", "getRenderState", "()Lnet/justmachinery/shade/render/ComponentRenderState;", "onTagStart", "", "tag", "Lkotlinx/html/Tag;", "onTagEnd", "isShadeDirective", "", "shade"})
public final class RenderTreeRecorder {
    @NotNull
    private final Stack<RenderTreeLocationFrame> frameStack;
    @NotNull
    private final ComponentRenderState renderState;

    public RenderTreeRecorder(@NotNull Stack<RenderTreeLocationFrame> frameStack, @NotNull ComponentRenderState renderState) {
        Intrinsics.checkNotNullParameter(frameStack, (String)"frameStack");
        Intrinsics.checkNotNullParameter((Object)renderState, (String)"renderState");
        this.frameStack = frameStack;
        this.renderState = renderState;
    }

    @NotNull
    public final Stack<RenderTreeLocationFrame> getFrameStack() {
        return this.frameStack;
    }

    @NotNull
    public final ComponentRenderState getRenderState() {
        return this.renderState;
    }

    public final void onTagStart(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!this.isShadeDirective(tag)) {
            RenderTreeLocationFrame oldFrame = this.frameStack.peek();
            RenderTreeLocation child = new RenderTreeLocation(oldFrame.getNewRenderTreeLocation(), tag.getTagName(), oldFrame.getRenderTreeChildIndex(), null, null, 16, null);
            Object object = oldFrame.getOldRenderTreeLocation();
            RenderTreeChild oldLocation = object != null && (object = ((RenderTreeLocation)object).getChildren()) != null ? (RenderTreeChild)CollectionsKt.getOrNull((List)object, (int)oldFrame.getRenderTreeChildIndex()) : null;
            RenderTreeLocationFrame newFrame = new RenderTreeLocationFrame(oldLocation != null && oldLocation instanceof RenderTreeChild.TagChild && Intrinsics.areEqual((Object)((RenderTreeChild.TagChild)oldLocation).getChild().getTagName(), (Object)tag.getTagName()) ? ((RenderTreeChild.TagChild)oldLocation).getChild() : null, child, 0, 4, null);
            this.frameStack.push(newFrame);
            oldFrame.setRenderTreeChildIndex(oldFrame.getRenderTreeChildIndex() + 1);
            this.renderState.setLocation(newFrame);
        }
    }

    public final void onTagEnd(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!this.isShadeDirective(tag)) {
            RenderTreeLocationFrame endingFrame = this.frameStack.pop();
            RenderTreeLocationFrame parentFrame = this.frameStack.peek();
            RenderTreeLocation it = endingFrame.getNewRenderTreeLocation();
            boolean bl = false;
            it.setKey((String)tag.getAttributes().get("key"));
            Object object = parentFrame;
            if (object != null && (object = ((RenderTreeLocationFrame)object).getNewRenderTreeLocation()) != null && (object = ((RenderTreeLocation)object).getChildren()) != null) {
                object.add((RenderTreeChild)new RenderTreeChild.TagChild(it));
            }
            this.renderState.setLocation(parentFrame);
        }
    }

    private final boolean isShadeDirective(Tag $this$isShadeDirective) {
        return StringsKt.equals((String)$this$isShadeDirective.getTagName(), (String)"script", (boolean)true) && Intrinsics.areEqual($this$isShadeDirective.getAttributes().get("type"), (Object)"shade");
    }
}

