/*
 * Decompiled with CFR 0.152.
 */
package net.justmachinery.shade.render;

import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.html.Tag;
import net.justmachinery.shade.component.ComponentInternalKt;
import net.justmachinery.shade.render.ComponentRenderState;
import net.justmachinery.shade.render.HtmlKt;
import net.justmachinery.shade.render.RenderTreeChild;
import net.justmachinery.shade.render.RenderTreeLocation;
import net.justmachinery.shade.render.RenderTreeLocationFrame;
import net.justmachinery.shade.render.RenderTreeRecorder;
import net.justmachinery.shade.render.RenderTreeTagLocation;
import net.justmachinery.shade.render.ShadeConsumer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a<\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0006*\u0002H\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\b\u000bH\u0000\u00a2\u0006\u0002\u0010\f\u001a@\u0010\r\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u000e\u001a\u0002H\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0002\b\u000bH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0002H\u0000\u00a8\u0006\u0015"}, d2={"toRenderTreeTagLocation", "Lnet/justmachinery/shade/render/RenderTreeTagLocation;", "Lnet/justmachinery/shade/render/RenderTreeLocation;", "updateRenderTree", "", "T", "Lkotlinx/html/Tag;", "renderState", "Lnet/justmachinery/shade/render/ComponentRenderState;", "cb", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlinx/html/Tag;Lnet/justmachinery/shade/render/ComponentRenderState;Lkotlin/jvm/functions/Function1;)V", "renderTreeTagRecorder", "parentTag", "(Lkotlinx/html/Tag;Lnet/justmachinery/shade/render/ComponentRenderState;Lkotlin/jvm/functions/Function1;)Lkotlinx/html/Tag;", "unmountDiffInRenderTrees", "oldRoot", "newRoot", "unmountAll", "root", "shade"})
@SourceDebugExtension(value={"SMAP\nRenderTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderTree.kt\nnet/justmachinery/shade/render/RenderTreeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1869#2,2:162\n*S KotlinDebug\n*F\n+ 1 RenderTree.kt\nnet/justmachinery/shade/render/RenderTreeKt\n*L\n153#1:162,2\n*E\n"})
public final class RenderTreeKt {
    @NotNull
    public static final RenderTreeTagLocation toRenderTreeTagLocation(@NotNull RenderTreeLocation $this$toRenderTreeTagLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$toRenderTreeTagLocation, (String)"<this>");
        RenderTreeLocation renderTreeLocation = $this$toRenderTreeTagLocation.getParent();
        return new RenderTreeTagLocation(renderTreeLocation != null ? RenderTreeKt.toRenderTreeTagLocation(renderTreeLocation) : null, $this$toRenderTreeTagLocation.getTagName(), $this$toRenderTreeTagLocation.getKey() != null ? -1 : $this$toRenderTreeTagLocation.getTagIndex(), $this$toRenderTreeTagLocation.getKey());
    }

    public static final <T extends Tag> void updateRenderTree(@NotNull T $this$updateRenderTree, @NotNull ComponentRenderState renderState, @NotNull Function1<? super T, Unit> cb) {
        Intrinsics.checkNotNullParameter($this$updateRenderTree, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)renderState, (String)"renderState");
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        RenderTreeLocation oldRenderTree = renderState.getRenderTreeRoot();
        RenderTreeLocation newRoot = new RenderTreeLocation(null, "(root)", 0, null, null, 16, null);
        renderState.setRenderTreeRoot(newRoot);
        RenderTreeLocationFrame frame = new RenderTreeLocationFrame(oldRenderTree, newRoot, 0, 4, null);
        renderState.setLocation(frame);
        RenderTreeKt.renderTreeTagRecorder($this$updateRenderTree, renderState, cb);
        if (oldRenderTree != null) {
            RenderTreeKt.unmountDiffInRenderTrees(oldRenderTree, newRoot);
        }
        renderState.setLocation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final <T extends Tag> T renderTreeTagRecorder(@NotNull T parentTag, @NotNull ComponentRenderState renderState, @NotNull Function1<? super T, Unit> cb) {
        Intrinsics.checkNotNullParameter(parentTag, (String)"parentTag");
        Intrinsics.checkNotNullParameter((Object)renderState, (String)"renderState");
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        Stack<RenderTreeLocationFrame> frameStack = new Stack<RenderTreeLocationFrame>();
        RenderTreeLocationFrame renderTreeLocationFrame = renderState.getLocation();
        Intrinsics.checkNotNull((Object)renderTreeLocationFrame);
        frameStack.push(renderTreeLocationFrame);
        ShadeConsumer consumer = HtmlKt.getShade(parentTag.getConsumer());
        RenderTreeRecorder oldRecorder = consumer.getRecorder$shade();
        consumer.setRecorder$shade(new RenderTreeRecorder(frameStack, renderState));
        try {
            cb.invoke(parentTag);
        }
        finally {
            consumer.setRecorder$shade(oldRecorder);
        }
        return parentTag;
    }

    public static final void unmountDiffInRenderTrees(@NotNull RenderTreeLocation oldRoot, @NotNull RenderTreeLocation newRoot) {
        Intrinsics.checkNotNullParameter((Object)oldRoot, (String)"oldRoot");
        Intrinsics.checkNotNullParameter((Object)newRoot, (String)"newRoot");
        if (!Intrinsics.areEqual((Object)oldRoot.getTagName(), (Object)newRoot.getTagName())) {
            RenderTreeKt.unmountAll(oldRoot);
        } else {
            int n = oldRoot.getChildren().size();
            for (int i = 0; i < n; ++i) {
                RenderTreeChild oldChild = oldRoot.getChildren().get(i);
                RenderTreeChild newChild = (RenderTreeChild)CollectionsKt.getOrNull(newRoot.getChildren(), (int)i);
                if (oldChild instanceof RenderTreeChild.TagChild && newChild instanceof RenderTreeChild.TagChild) {
                    RenderTreeKt.unmountDiffInRenderTrees(((RenderTreeChild.TagChild)oldChild).getChild(), ((RenderTreeChild.TagChild)newChild).getChild());
                    continue;
                }
                if (Intrinsics.areEqual((Object)oldChild, (Object)newChild)) continue;
                RenderTreeChild renderTreeChild = oldChild;
                if (renderTreeChild instanceof RenderTreeChild.ComponentChild) {
                    ComponentInternalKt.doUnmount(((RenderTreeChild.ComponentChild)oldChild).getComponent());
                    continue;
                }
                if (renderTreeChild instanceof RenderTreeChild.TagChild) {
                    RenderTreeKt.unmountAll(((RenderTreeChild.TagChild)oldChild).getChild());
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static final void unmountAll(@NotNull RenderTreeLocation root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Iterable $this$forEach$iv = root.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RenderTreeChild it = (RenderTreeChild)element$iv;
            boolean bl = false;
            RenderTreeChild renderTreeChild = it;
            if (renderTreeChild instanceof RenderTreeChild.TagChild) {
                RenderTreeKt.unmountAll(((RenderTreeChild.TagChild)it).getChild());
                continue;
            }
            if (renderTreeChild instanceof RenderTreeChild.ComponentChild) {
                ComponentInternalKt.doUnmount(((RenderTreeChild.ComponentChild)it).getComponent());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }
}

