/*
 * Decompiled with CFR 0.152.
 */
package net.justmachinery.shade.render;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.html.HTML;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import net.justmachinery.shade.Client;
import net.justmachinery.shade.ContextErrorSource;
import net.justmachinery.shade.ContextKt;
import net.justmachinery.shade.DirectiveType;
import net.justmachinery.shade.ErrorsKt;
import net.justmachinery.shade.ShadeContext;
import net.justmachinery.shade.ShadeRootComponent;
import net.justmachinery.shade.SocketScopeNames;
import net.justmachinery.shade.component.AdvancedComponent;
import net.justmachinery.shade.component.ComponentInternalKt;
import net.justmachinery.shade.render.ComponentRenderState;
import net.justmachinery.shade.render.HtmlKt;
import net.justmachinery.shade.render.RenderBatch;
import net.justmachinery.shade.render.RenderTreeKt;
import net.justmachinery.shade.state.ChangeBatchChangePolicy;
import net.justmachinery.shade.state.ChangeBatchKt;
import net.justmachinery.shade.utility.UtilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004H\u0000\u001a\u0016\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004H\u0000\u001a\u0014\u0010\u000e\u001a\u00020\b*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a&\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0016H\u0000\u001a \u0010\u0017\u001a\u00020\b\"\b\b\u0000\u0010\u0018*\u00020\u0019*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00180\u0004H\u0002\u001a9\u0010\u001f\u001a\u00020\b\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0010\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00180\u00042\u0006\u0010\u0010\u001a\u0002H\u00182\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\u0010\"\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\",\u0010\u001a\u001a \u0012\r\u0012\u000b\u0012\u0002\b\u00030\u001c\u00a2\u0006\u0002\b\u001d\u0012\r\u0012\u000b\u0012\u0002\b\u00030\u001e\u00a2\u0006\u0002\b\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"threadRenderingBatch", "Ljava/lang/ThreadLocal;", "Lnet/justmachinery/shade/render/RenderBatch;", "currentlyRendering", "Lnet/justmachinery/shade/component/AdvancedComponent;", "getCurrentlyRendering", "()Ljava/lang/ThreadLocal;", "markDontRerender", "", "component", "runRenderBatch", "cb", "Lkotlin/Function0;", "addMounted", "renderRoot", "Lnet/justmachinery/shade/ShadeRootComponent;", "tag", "Lkotlinx/html/HTML;", "rerender", "client", "Lnet/justmachinery/shade/Client;", "components", "", "updateRender", "RenderIn", "Lkotlinx/html/Tag;", "tagConstructorCache", "Lcom/google/common/cache/LoadingCache;", "Ljava/lang/Class;", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/lang/reflect/Constructor;", "renderInternal", "addMarkers", "", "(Lnet/justmachinery/shade/component/AdvancedComponent;Lkotlinx/html/Tag;Z)V", "shade"})
@SourceDebugExtension(value={"SMAP\nRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Render.kt\nnet/justmachinery/shade/render/RenderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Client.kt\nnet/justmachinery/shade/Client\n+ 4 ThreadLocal.kt\nnet/justmachinery/futility/ThreadLocalKt\n+ 5 Context.kt\nnet/justmachinery/shade/ContextKt\n*L\n1#1,167:1\n1869#2,2:168\n1869#2,2:170\n1869#2:172\n1870#2:178\n170#3,5:173\n7#4,7:179\n7#4,7:187\n40#5:186\n*S KotlinDebug\n*F\n+ 1 Render.kt\nnet/justmachinery/shade/render/RenderKt\n*L\n160#1:168,2\n50#1:170,2\n84#1:172\n84#1:178\n86#1:173,5\n143#1:179,7\n141#1:187,7\n141#1:186\n*E\n"})
public final class RenderKt {
    @NotNull
    private static final ThreadLocal<RenderBatch> threadRenderingBatch = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<AdvancedComponent<?, ?>> currentlyRendering = new ThreadLocal();
    @NotNull
    private static final LoadingCache<Class<?>, Constructor<?>> tagConstructorCache;

    @NotNull
    public static final ThreadLocal<AdvancedComponent<?, ?>> getCurrentlyRendering() {
        return currentlyRendering;
    }

    public static final void markDontRerender(@NotNull AdvancedComponent<?, ?> component) {
        block0: {
            Intrinsics.checkNotNullParameter(component, (String)"component");
            RenderBatch batch = threadRenderingBatch.get();
            Object object = batch;
            if (object == null || (object = ((RenderBatch)object).getDontRerender()) == null) break block0;
            object.add(component);
        }
    }

    private static final void runRenderBatch(Function0<Unit> cb) {
        RenderBatch existingBatch = threadRenderingBatch.get();
        if (existingBatch != null) {
            cb.invoke();
        } else {
            RenderBatch newBatch = new RenderBatch(null, null, 3, null);
            threadRenderingBatch.set(newBatch);
            ChangeBatchKt.runChangeBatch(ChangeBatchChangePolicy.DISALLOWED, () -> RenderKt.runRenderBatch$lambda$2(cb, newBatch));
        }
    }

    public static final void addMounted(@NotNull AdvancedComponent<?, ?> component) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        RenderBatch renderBatch = threadRenderingBatch.get();
        if (renderBatch == null) {
            throw new IllegalStateException("Cannot add component outside render batch: " + component);
        }
        RenderBatch batch = renderBatch;
        batch.getMountedComponents().add(component);
    }

    public static final void renderRoot(@NotNull ShadeRootComponent $this$renderRoot, @NotNull HTML tag) {
        Intrinsics.checkNotNullParameter((Object)$this$renderRoot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        RenderKt.runRenderBatch((Function0<Unit>)((Function0)() -> RenderKt.renderRoot$lambda$3($this$renderRoot, tag)));
    }

    public static final void rerender(@NotNull Client client, @NotNull List<? extends AdvancedComponent<?, ?>> components) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        RenderKt.runRenderBatch((Function0<Unit>)((Function0)() -> RenderKt.rerender$lambda$7(components, client)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <RenderIn extends Tag> void updateRender(AdvancedComponent<?, RenderIn> $this$updateRender) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean bl = false;
        Closeable closeable = baos;
        Charset charset = Charsets.UTF_8;
        closeable = new OutputStreamWriter((OutputStream)closeable, charset);
        int n = 8192;
        closeable = closeable instanceof BufferedWriter ? (BufferedWriter)closeable : new BufferedWriter((Writer)closeable, n);
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl2 = false;
            TagConsumer<Unit> consumer = HtmlKt.shadeToWriter(it);
            Object[] objectArray = new Object[]{MapsKt.emptyMap(), consumer};
            Tag tag = (Tag)((Constructor)tagConstructorCache.get((Object)JvmClassMappingKt.getJavaClass($this$updateRender.getRenderIn$shade()))).newInstance(objectArray);
            HtmlKt.getShade(consumer).setContainerTag$shade(tag);
            Intrinsics.checkNotNull((Object)tag, (String)"null cannot be cast to non-null type RenderIn of net.justmachinery.shade.render.RenderKt.updateRender");
            RenderKt.renderInternal($this$updateRender, tag, false);
            consumer.finalize();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String html = baos.toString(Charsets.UTF_8);
        String escapedHtml = UtilityKt.getGson().toJson((Object)html);
        $this$updateRender.getClient().executeScript(SocketScopeNames.reconcile.getRaw() + "(" + $this$updateRender.getRenderState$shade().getComponentId() + "," + escapedHtml + ");");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <RenderIn extends Tag> void renderInternal(@NotNull AdvancedComponent<?, RenderIn> component, @NotNull RenderIn tag, boolean addMarkers) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(tag, (String)"tag");
        ComponentRenderState renderState = component.getRenderState$shade();
        SortedSet<Long> oldRenderCallbackIds = renderState.getLastRenderCallbackIds();
        renderState.setLastRenderCallbackIds(new TreeSet());
        RenderKt.markDontRerender(component);
        if (addMarkers) {
            HtmlKt.scriptDirective$default(tag, DirectiveType.ComponentStart, "shade" + renderState.getComponentId(), component.getKey$shade(), null, 8, null);
        }
        try {
            RenderTreeKt.updateRenderTree(tag, renderState, arg_0 -> RenderKt.renderInternal$lambda$15(component, arg_0));
        }
        finally {
            if (addMarkers) {
                HtmlKt.scriptDirective$default(tag, DirectiveType.ComponentEnd, "shade" + renderState.getComponentId() + "e", null, null, 12, null);
            }
            Sets.SetView setView = Sets.difference((Set)oldRenderCallbackIds, (Set)renderState.getLastRenderCallbackIds());
            Intrinsics.checkNotNullExpressionValue((Object)setView, (String)"difference(...)");
            Iterable $this$forEach$iv = (Iterable)setView;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Long it = (Long)element$iv;
                boolean bl = false;
                Client client = component.getClient();
                Intrinsics.checkNotNull((Object)it);
                client.removeCallback$shade(it);
                renderState.getRenderTreePathToCallbackId().inverse().remove((Object)it);
            }
        }
    }

    private static final Unit runRenderBatch$lambda$2$lambda$1(RenderBatch $newBatch) {
        Iterable $this$forEach$iv = $newBatch.getMountedComponents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AdvancedComponent it = (AdvancedComponent)element$iv;
            boolean bl = false;
            ComponentInternalKt.doMount(it);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Unit runRenderBatch$lambda$2(Function0 $cb, RenderBatch $newBatch) {
        try {
            $cb.invoke();
            threadRenderingBatch.remove();
            if (!(!((Collection)$newBatch.getMountedComponents()).isEmpty())) return Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            threadRenderingBatch.remove();
            if (!(!((Collection)$newBatch.getMountedComponents()).isEmpty())) throw throwable;
            ChangeBatchKt.runChangeBatch(ChangeBatchChangePolicy.FORCE_ALLOWED, () -> RenderKt.runRenderBatch$lambda$2$lambda$1($newBatch));
            throw throwable;
        }
        ChangeBatchKt.runChangeBatch(ChangeBatchChangePolicy.FORCE_ALLOWED, () -> RenderKt.runRenderBatch$lambda$2$lambda$1($newBatch));
        return Unit.INSTANCE;
    }

    private static final Unit renderRoot$lambda$3(ShadeRootComponent $this_renderRoot, HTML $tag) {
        RenderKt.renderInternal($this_renderRoot, (Tag)$tag, false);
        return Unit.INSTANCE;
    }

    private static final String rerender$lambda$7$lambda$6$lambda$4(AdvancedComponent $it) {
        return "While rerendering " + $it;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit rerender$lambda$7(List $components, Client $client) {
        Iterable $this$forEach$iv = $components;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit unit;
            AdvancedComponent it = (AdvancedComponent)element$iv;
            boolean bl = false;
            if (threadRenderingBatch.get().getDontRerender().contains(it)) continue;
            Client client = $client;
            Function0 message$iv = () -> RenderKt.rerender$lambda$7$lambda$6$lambda$4(it);
            boolean $i$f$swallowExceptions$shade = false;
            try {
                boolean bl2 = false;
                RenderKt.updateRender(it);
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv) {
                void this_$iv;
                this_$iv.swallowException$shade((Function0<String>)message$iv, t$iv);
                unit = null;
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit renderInternal$lambda$15$lambda$14$lambda$13$lambda$12(AdvancedComponent $component, Tag $this_updateRenderTree) {
        void $this$withValue$iv;
        ThreadLocal<AdvancedComponent<?, ?>> threadLocal = currentlyRendering;
        AdvancedComponent value$iv = $component;
        boolean $i$f$withValue = false;
        Object oldValue$iv = $this$withValue$iv.get();
        $this$withValue$iv.set(value$iv);
        try {
            boolean bl = false;
            AdvancedComponent $this$renderInternal_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = $component;
            boolean bl2 = false;
            $this$renderInternal_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.render($this_updateRenderTree);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withValue$iv.set(oldValue$iv);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit renderInternal$lambda$15$lambda$14(AdvancedComponent $component, Tag $this_updateRenderTree) {
        void $this$withValue$iv$iv;
        ShadeContext context$iv = $component.getBaseContext$shade();
        boolean $i$f$withShadeContext = false;
        ThreadLocal<ShadeContext> threadLocal = ContextKt.getContextInRenderingThread();
        ShadeContext value$iv$iv = context$iv;
        boolean $i$f$withValue = false;
        Object oldValue$iv$iv = $this$withValue$iv$iv.get();
        $this$withValue$iv$iv.set(value$iv$iv);
        try {
            boolean bl = false;
            ErrorsKt.handlingErrors($component, ContextErrorSource.RENDER, () -> RenderKt.renderInternal$lambda$15$lambda$14$lambda$13$lambda$12($component, $this_updateRenderTree));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withValue$iv$iv.set(oldValue$iv$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderInternal$lambda$15(AdvancedComponent $component, Tag $this$updateRenderTree) {
        Intrinsics.checkNotNullParameter((Object)$this$updateRenderTree, (String)"$this$updateRenderTree");
        $component.getRenderDependencies$shade().runRecordingDependencies$shade(() -> RenderKt.renderInternal$lambda$15$lambda$14($component, $this$updateRenderTree));
        return Unit.INSTANCE;
    }

    static {
        LoadingCache loadingCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Constructor<?>>(){

            public Constructor<?> load(Class<?> key) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Class[] classArray = new Class[]{Map.class, TagConsumer.class};
                Constructor<?> constructor = key.getDeclaredConstructor(classArray);
                constructor.setAccessible(true);
                Intrinsics.checkNotNull(constructor);
                return constructor;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        tagConstructorCache = loadingCache;
    }
}

