/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.util.UUID;
import org.apache.commons.dbcp.BasicDataSource;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;

public class ManagedBasicDataSource
extends BasicDataSource {
    public static final String DEFAULT_MBEAN_NAME = "org.apache.commons.dbcp:ManagedBasicDataSource=ManagedBasicDataSource";
    protected final String mBeanName;

    public ManagedBasicDataSource() {
        this("org.apache.commons.dbcp:ManagedBasicDataSource=ManagedBasicDataSource-" + UUID.randomUUID());
    }

    public ManagedBasicDataSource(String mBeanName) {
        this.mBeanName = mBeanName;
        this.exportMBean(mBeanName);
    }

    protected synchronized void exportMBean(String name) {
        MBeanExporter.withPlatformMBeanServer().export(name, (Object)this);
    }

    public String getMBeanName() {
        return this.mBeanName;
    }

    @Managed(description="The current number of active connections that have been allocated from this data source.")
    public synchronized int getNumActive() {
        return super.getNumActive();
    }

    @Managed(description="The current number of idle connections that are waiting to be allocated from this data source.")
    public synchronized int getNumIdle() {
        return super.getNumIdle();
    }

    @Managed(description="The maximum number of active connections that can be allocated at the same time.")
    public synchronized int getMaxActive() {
        return super.getMaxActive();
    }

    @Managed(description="Set the maximum number of active connections that can be allocated at the same time. Use a negative value for no limit.")
    public synchronized void setMaxActive(int maxActive) {
        super.setMaxActive(maxActive);
    }

    @Managed(description="The maximum number of connections that can remain idle in the pool.")
    public synchronized int getMaxIdle() {
        return super.getMaxIdle();
    }

    @Managed(description="Set the maximum number of connections that can remain idle in the pool.")
    public synchronized void setMaxIdle(int maxIdle) {
        super.setMaxIdle(maxIdle);
    }

    @Managed(description="The minimum number of idle connections in the pool.")
    public synchronized int getMinIdle() {
        return super.getMinIdle();
    }

    @Managed(description="The minimum number of idle connections in the pool.")
    public synchronized void setMinIdle(int minIdle) {
        super.setMinIdle(minIdle);
    }

    @Managed(description="The maximum number of milliseconds that the pool will wait for a connection to be returned before throwing an exception.")
    public synchronized long getMaxWait() {
        return super.getMaxWait();
    }

    @Managed(description="Set the maxWait property. Use -1 to make the pool wait indefinitely.")
    public synchronized void setMaxWait(long maxWait) {
        super.setMaxWait(maxWait);
    }

    @Managed
    public synchronized String getUrl() {
        return super.getUrl();
    }

    @Managed
    public String getUsername() {
        return super.getUsername();
    }
}

