/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.spring;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Optional;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.ParameterResolutionContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.spring.JqwikSpringExtension;
import org.springframework.beans.factory.annotation.ParameterResolutionDelegate;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.support.TestConstructorUtils;

class ResolveSpringParametersHook
implements ResolveParameterHook {
    ResolveSpringParametersHook() {
    }

    public Optional<ResolveParameterHook.ParameterSupplier> resolve(ParameterResolutionContext parameterContext, LifecycleContext lifecycleContext) {
        Parameter parameter = parameterContext.parameter();
        Class<?> containerClass = parameterContext.parameter().getDeclaringExecutable().getDeclaringClass();
        TestContextManager testContextManager = JqwikSpringExtension.getTestContextManager(containerClass);
        if (this.canParameterBeResolved(parameterContext.index(), parameter)) {
            return Optional.of(new SpringSupplier(parameterContext, lifecycleContext, testContextManager));
        }
        return Optional.empty();
    }

    private boolean canParameterBeResolved(int index, Parameter parameter) {
        return ApplicationContext.class.isAssignableFrom(parameter.getType()) || ParameterResolutionDelegate.isAutowirable((Parameter)parameter, (int)index) || this.isAutowirableConstructor(parameter);
    }

    private boolean isAutowirableConstructor(Parameter parameter) {
        Executable executable = parameter.getDeclaringExecutable();
        Class<?> testClass = executable.getDeclaringClass();
        return TestConstructorUtils.isAutowirableConstructor((Executable)executable, testClass);
    }

    private static class SpringSupplier
    implements ResolveParameterHook.ParameterSupplier {
        private ParameterResolutionContext parameterContext;
        private LifecycleContext lifecycleContext;
        private TestContextManager testContextManager;

        public SpringSupplier(ParameterResolutionContext parameterContext, LifecycleContext lifecycleContext, TestContextManager testContextManager) {
            this.parameterContext = parameterContext;
            this.lifecycleContext = lifecycleContext;
            this.testContextManager = testContextManager;
        }

        public Object get(Optional<TryLifecycleContext> optionalTry) {
            Parameter parameter = this.parameterContext.parameter();
            int index = this.parameterContext.index();
            return this.lifecycleContext.optionalContainerClass().map(testClass -> {
                ApplicationContext applicationContext = this.testContextManager.getTestContext().getApplicationContext();
                return ParameterResolutionDelegate.resolveDependency((Parameter)parameter, (int)index, (Class)testClass, (AutowireCapableBeanFactory)applicationContext.getAutowireCapableBeanFactory());
            }).orElseThrow(() -> {
                String message = String.format("Trying to resolve Spring parameter outside container context: %s", this.lifecycleContext.label());
                return new JqwikException(message);
            });
        }
    }
}

