/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.spring;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.spring.JqwikSpringExtension;
import net.jqwik.spring.JqwikSpringReflectionSupport;
import org.springframework.test.context.TestContextManager;

class OutsideLifecycleMethodsHook
implements AroundTryHook {
    OutsideLifecycleMethodsHook() {
    }

    public boolean appliesTo(Optional<AnnotatedElement> optionalElement) {
        return optionalElement.map(element -> element instanceof Method).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TryExecutionResult aroundTry(TryLifecycleContext context, TryExecutor aTry, List<Object> parameters) throws Exception {
        TryExecutionResult tryExecutionResult;
        Class containerClass = context.containerClass();
        Object testInstance = context.testInstance();
        this.prepareTestInstance(testInstance);
        TestContextManager testContextManager = JqwikSpringExtension.getTestContextManager(containerClass);
        Method testMethod = context.targetMethod();
        this.beforeExecutionHooks(testContextManager, testInstance, testMethod);
        Throwable testException = null;
        try {
            TryExecutionResult executionResult = aTry.execute(parameters);
            testException = executionResult.throwable().orElse(null);
            tryExecutionResult = executionResult;
        }
        catch (Throwable throwable) {
            this.afterExecutionHooks(testContextManager, testInstance, testMethod, testException);
            throw throwable;
        }
        this.afterExecutionHooks(testContextManager, testInstance, testMethod, testException);
        return tryExecutionResult;
    }

    public int aroundTryProximity() {
        return -20;
    }

    private void prepareTestInstance(Object testInstance) throws Exception {
        JqwikSpringReflectionSupport.applyToInstances(testInstance, instance -> {
            TestContextManager testContextManager = JqwikSpringExtension.getTestContextManager(instance.getClass());
            testContextManager.prepareTestInstance(instance);
        });
    }

    private void beforeExecutionHooks(TestContextManager testContextManager, Object testInstance, Method testMethod) throws Exception {
        testContextManager.beforeTestMethod(testInstance, testMethod);
    }

    private void afterExecutionHooks(TestContextManager testContextManager, Object testInstance, Method testMethod, Throwable testException) throws Exception {
        testContextManager.afterTestMethod(testInstance, testMethod, testException);
    }
}

