/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.spring;

import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

class JqwikSpringReflectionSupport {
    JqwikSpringReflectionSupport() {
    }

    static void applyToInstances(Object instance, Applier codeToApply) throws Exception {
        List<Object> instances = JqwikSpringReflectionSupport.getInstances(instance);
        for (Object i : instances) {
            codeToApply.apply(i);
        }
    }

    private static List<Object> getInstances(Object instance) {
        return JqwikSpringReflectionSupport.getInstances(instance, new ArrayList<Object>());
    }

    private static List<Object> getInstances(Object inner, List<Object> innerInstances) {
        Optional<Object> optionalOuter = JqwikSpringReflectionSupport.getOuterInstance(inner);
        innerInstances.add(0, inner);
        return optionalOuter.map(outer -> JqwikSpringReflectionSupport.getInstances(outer, innerInstances)).orElse(innerInstances);
    }

    private static Optional<Object> getOuterInstance(Object inner) {
        return Arrays.stream(inner.getClass().getDeclaredFields()).filter(field -> field.getName().startsWith("this$")).findFirst().map(field -> {
            try {
                return JqwikSpringReflectionSupport.makeAccessible(field).get(inner);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                return Optional.empty();
            }
        });
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    static interface Applier {
        public void apply(Object var1) throws Exception;
    }
}

