/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.spring;

import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.SkipExecutionHook;
import net.jqwik.spring.JupiterExtensionContextAdapter;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.test.context.junit.jupiter.DisabledIf;
import org.springframework.test.context.junit.jupiter.DisabledIfCondition;

class DisabledIfHook
implements SkipExecutionHook {
    DisabledIfHook() {
    }

    public SkipExecutionHook.SkipResult shouldBeSkipped(LifecycleContext context) {
        if (!context.findAnnotation(DisabledIf.class).isPresent()) {
            return SkipExecutionHook.SkipResult.doNotSkip();
        }
        JupiterExtensionContextAdapter extensionContext = new JupiterExtensionContextAdapter(context);
        ConditionEvaluationResult evaluationResult = new DisabledIfCondition().evaluateExecutionCondition((ExtensionContext)extensionContext);
        if (evaluationResult.isDisabled()) {
            return SkipExecutionHook.SkipResult.skip((String)evaluationResult.getReason().orElse(null));
        }
        return SkipExecutionHook.SkipResult.doNotSkip();
    }
}

