/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import net.jqwik.engine.support.JqwikAnnotationSupport;
import net.jqwik.engine.support.TypeResolution;
import org.junit.platform.commons.support.AnnotationSupport;

public class MethodParameter {
    private final Parameter parameter;
    private final TypeResolution resolution;

    public MethodParameter(Parameter parameter, TypeResolution resolution) {
        this.parameter = parameter;
        this.resolution = resolution;
    }

    public boolean isAnnotatedParameterized() {
        return this.resolution.annotatedType() instanceof AnnotatedParameterizedType;
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationType) {
        return AnnotationSupport.isAnnotated((AnnotatedElement)this.parameter, annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)this.findAnnotation(annotationClass).orElse(null));
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotationClass) {
        return AnnotationSupport.findAnnotation((AnnotatedElement)this.parameter, annotationClass);
    }

    public Type getType() {
        return this.resolution.type();
    }

    public String toString() {
        return this.parameter.toString();
    }

    public List<Annotation> findAllAnnotations() {
        return JqwikAnnotationSupport.findAllAnnotations(this.parameter);
    }

    public AnnotatedParameterizedType getAnnotatedType() {
        if (this.isAnnotatedParameterized()) {
            return (AnnotatedParameterizedType)this.resolution.annotatedType();
        }
        return null;
    }
}

