/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.StringUtils;

public class JqwikStringSupport {
    public static String parameterTypesToString(Class<?> ... classes) {
        return ClassUtils.nullSafeToString((Class[])classes);
    }

    public static String displayString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            String elements = collection.stream().map(JqwikStringSupport::displayString).collect(Collectors.joining(", "));
            return String.format("[%s]", elements);
        }
        if (object.getClass().isArray()) {
            if (object.getClass().getComponentType().isPrimitive()) {
                return StringUtils.nullSafeToString((Object)object);
            }
            Object[] array = (Object[])object;
            String elements = Arrays.stream(array).map(JqwikStringSupport::displayString).collect(Collectors.joining(", "));
            return String.format("%s{%s}", object.getClass().getSimpleName(), elements);
        }
        if (String.class.isAssignableFrom(object.getClass())) {
            return String.format("\"%s\"", object.toString());
        }
        return object.toString();
    }
}

