/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.lifecycle.LifecycleHook;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.discovery.predicates.IsTopLevelClass;
import net.jqwik.engine.support.GenericsClassContext;
import net.jqwik.engine.support.GenericsSupport;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.TypeResolution;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class JqwikReflectionSupport {
    private static final IsTopLevelClass isTopLevelClass = new IsTopLevelClass();

    public static Stream<Object> streamInstancesFromInside(Object inner) {
        return JqwikReflectionSupport.addInstances(inner, new ArrayList<Object>()).stream();
    }

    private static List<Object> addInstances(Object inner, List<Object> instances) {
        instances.add(inner);
        Optional<Object> outer = JqwikReflectionSupport.getOuterInstance(inner);
        outer.ifPresent(o -> JqwikReflectionSupport.addInstances(o, instances));
        return instances;
    }

    private static Optional<Object> getOuterInstance(Object inner) {
        return Arrays.stream(inner.getClass().getDeclaredFields()).filter(field -> field.getName().startsWith("this$")).findFirst().map(field -> {
            try {
                return JqwikReflectionSupport.makeAccessible(field).get(inner);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                return Optional.empty();
            }
        });
    }

    private static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    public static <T> T newInstanceWithDefaultConstructor(Class<T> clazz) {
        if (isTopLevelClass.test(clazz) || JqwikReflectionSupport.isStatic(clazz)) {
            return (T)ReflectionSupport.newInstance(clazz, (Object[])new Object[0]);
        }
        Object parentInstance = JqwikReflectionSupport.newInstanceWithDefaultConstructor(clazz.getDeclaringClass());
        return (T)ReflectionSupport.newInstance(clazz, (Object[])new Object[]{parentInstance});
    }

    public static List<Method> findMethodsPotentiallyOuter(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        ArrayList<Method> foundMethods = new ArrayList<Method>();
        foundMethods.addAll(ReflectionSupport.findMethods(clazz, predicate, (HierarchyTraversalMode)traversalMode));
        Class<?> searchClass = clazz;
        while (searchClass.getDeclaringClass() != null) {
            searchClass = searchClass.getDeclaringClass();
            foundMethods.addAll(ReflectionSupport.findMethods(searchClass, predicate, (HierarchyTraversalMode)traversalMode));
        }
        return foundMethods;
    }

    public static Object invokeMethodPotentiallyOuter(Method method, Object target, Object ... args) {
        Optional<Object> newTarget;
        if (method.getDeclaringClass().isAssignableFrom(target.getClass())) {
            return ReflectionSupport.invokeMethod((Method)method, (Object)target, (Object[])args);
        }
        if (target.getClass().getDeclaringClass() != null && (newTarget = JqwikReflectionSupport.getOuterInstance(target)).isPresent()) {
            return JqwikReflectionSupport.invokeMethodPotentiallyOuter(method, newTarget.get(), args);
        }
        throw new IllegalArgumentException(String.format("Method [%s] cannot be invoked on target [%s].", method, target));
    }

    public static Set<Path> getAllClasspathRootDirectories() {
        String classpath = System.getProperty("java.class.path");
        return Arrays.stream(classpath.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toSet());
    }

    public static MethodParameter[] getMethodParameters(Method method, Class<?> containerClass) {
        ArrayList<MethodParameter> list = new ArrayList<MethodParameter>();
        Parameter[] parameters = method.getParameters();
        GenericsClassContext containerClassContext = GenericsSupport.contextFor(containerClass);
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            TypeResolution resolution = containerClassContext.resolveParameter(parameter);
            MethodParameter methodParameter = new MethodParameter(parameter, resolution);
            list.add(methodParameter);
        }
        return list.toArray(new MethodParameter[parameters.length]);
    }

    public static Optional<Method> findGeneratorMethod(String generatorToFind, Class<?> containerClass, Class<? extends Annotation> requiredGeneratorAnnotation, Function<Method, String> generatorNameSupplier, TypeUsage targetType) {
        List<Method> creators = JqwikReflectionSupport.findMethodsPotentiallyOuter(containerClass, JqwikReflectionSupport.isGeneratorMethod(targetType, requiredGeneratorAnnotation), HierarchyTraversalMode.BOTTOM_UP);
        return creators.stream().filter(generatorMethod -> {
            String generatorName = (String)generatorNameSupplier.apply((Method)generatorMethod);
            if (generatorName.isEmpty()) {
                generatorName = generatorMethod.getName();
            }
            return generatorName.equals(generatorToFind);
        }).findFirst();
    }

    public static Predicate<Method> isGeneratorMethod(TypeUsage targetType, Class<? extends Annotation> requiredAnnotation) {
        return method -> {
            if (!method.isAnnotationPresent(requiredAnnotation)) {
                return false;
            }
            TypeUsage generatorReturnType = TypeUsage.forType((Type)method.getAnnotatedReturnType().getType());
            return generatorReturnType.canBeAssignedTo(targetType);
        };
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(Member member) {
        return Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isInnerClass(Class<? extends LifecycleHook> hookClass) {
        return hookClass.isMemberClass() && !JqwikReflectionSupport.isStatic(hookClass);
    }
}

