/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import net.jqwik.engine.support.GenericsClassContext;

public class GenericsSupport {
    private static Map<Class, GenericsClassContext> contextsCache = new HashMap<Class, GenericsClassContext>();

    public static synchronized GenericsClassContext contextFor(Class<?> contextClass) {
        if (contextClass == null) {
            return GenericsClassContext.NULL;
        }
        return contextsCache.computeIfAbsent(contextClass, GenericsSupport::createContext);
    }

    private static GenericsClassContext createContext(Class<?> contextClass) {
        GenericsClassContext context = new GenericsClassContext(contextClass);
        GenericsSupport.addResolutionForSuperclass(contextClass, context);
        GenericsSupport.addResolutionForInterfaces(contextClass, context);
        return context;
    }

    private static void addResolutionForInterfaces(Class<?> contextClass, GenericsClassContext context) {
        Class<?>[] interfaces = contextClass.getInterfaces();
        Type[] genericInterfaces = contextClass.getGenericInterfaces();
        AnnotatedType[] annotatedInterfaces = contextClass.getAnnotatedInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> supertype = interfaces[i];
            Type genericSupertype = genericInterfaces[i];
            AnnotatedType annotatedSupertype = annotatedInterfaces[i];
            GenericsSupport.addResolutionForSupertype(supertype, genericSupertype, annotatedSupertype, context);
        }
    }

    private static void addResolutionForSuperclass(Class<?> contextClass, GenericsClassContext context) {
        GenericsSupport.addResolutionForSupertype(contextClass.getSuperclass(), contextClass.getGenericSuperclass(), contextClass.getAnnotatedSuperclass(), context);
    }

    private static void addResolutionForSupertype(Class<?> supertype, Type genericSupertype, AnnotatedType annotatedSupertype, GenericsClassContext context) {
        if (genericSupertype instanceof ParameterizedType) {
            ParameterizedType genericParameterizedType = (ParameterizedType)genericSupertype;
            Type[] supertypeTypeArguments = genericParameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] superclassTypeVariables = supertype.getTypeParameters();
            AnnotatedType[] annotatedTypeVariables = ((AnnotatedParameterizedType)annotatedSupertype).getAnnotatedActualTypeArguments();
            for (int i = 0; i < superclassTypeVariables.length; ++i) {
                TypeVariable<Class<?>> variable = superclassTypeVariables[i];
                Type resolvedType = supertypeTypeArguments[i];
                AnnotatedType annotatedType = annotatedTypeVariables[i];
                context.addResolution(variable, resolvedType, annotatedType);
            }
        }
    }
}

