/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import net.jqwik.api.providers.ArbitraryProvider;

public class RegisteredArbitraryProviders {
    private static List<ArbitraryProvider> registeredProviders;

    public static List<ArbitraryProvider> getProviders() {
        if (null == registeredProviders) {
            RegisteredArbitraryProviders.loadArbitraryProviders();
        }
        return Collections.unmodifiableList(new ArrayList<ArbitraryProvider>(registeredProviders));
    }

    private static void loadArbitraryProviders() {
        registeredProviders = new ArrayList<ArbitraryProvider>();
        ServiceLoader<ArbitraryProvider> providers = ServiceLoader.load(ArbitraryProvider.class);
        for (ArbitraryProvider provider : providers) {
            RegisteredArbitraryProviders.register(provider);
        }
    }

    public static void register(ArbitraryProvider provider) {
        if (RegisteredArbitraryProviders.getProviders().contains(provider)) {
            return;
        }
        registeredProviders.add(0, provider);
    }

    public static void unregister(ArbitraryProvider providerToDelete) {
        RegisteredArbitraryProviders.getProviders().stream().filter(provider -> provider == providerToDelete).forEach(provider -> registeredProviders.remove(provider));
    }

    public static void unregister(Class<? extends ArbitraryProvider> providerClass) {
        RegisteredArbitraryProviders.getProviders().stream().filter(provider -> provider.getClass() == providerClass).forEach(provider -> registeredProviders.remove(provider));
    }
}

