/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.math.BigInteger;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.properties.arbitraries.Range;
import net.jqwik.engine.properties.shrinking.AbstractShrinkable;
import net.jqwik.engine.properties.shrinking.BigIntegerShrinkingCandidates;

public class ShrinkableBigInteger
extends AbstractShrinkable<BigInteger> {
    private final Range<BigInteger> range;
    private final BigInteger target;
    private final BigIntegerShrinkingCandidates shrinkingCandidates;

    public ShrinkableBigInteger(BigInteger value, Range<BigInteger> range) {
        super(value);
        this.range = range;
        this.target = this.determineTarget(value);
        this.shrinkingCandidates = new BigIntegerShrinkingCandidates(this.target);
    }

    @Override
    public Set<Shrinkable<BigInteger>> shrinkCandidatesFor(Shrinkable<BigInteger> shrinkable) {
        return this.shrinkingCandidates.candidatesFor((BigInteger)shrinkable.value()).stream().map(aBigInteger -> new ShrinkableBigInteger((BigInteger)aBigInteger, this.range)).collect(Collectors.toSet());
    }

    public ShrinkingDistance distance() {
        return ShrinkableBigInteger.distanceFor((BigInteger)this.value(), this.target);
    }

    static ShrinkingDistance distanceFor(BigInteger value, BigInteger target) {
        BigInteger distance = value.subtract(target).abs();
        if (distance.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
            return ShrinkingDistance.of((long[])new long[]{Long.MAX_VALUE});
        }
        return ShrinkingDistance.of((long[])new long[]{distance.longValueExact()});
    }

    private BigInteger determineTarget(BigInteger value) {
        if (!this.range.includes(value)) {
            String message = String.format("Number <%s> is outside allowed range %s", value, this.range);
            throw new JqwikException(message);
        }
        if (this.range.includes(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        if (value.compareTo(BigInteger.ZERO) < 0) {
            return (BigInteger)this.range.max;
        }
        if (value.compareTo(BigInteger.ZERO) > 0) {
            return (BigInteger)this.range.min;
        }
        return value;
    }
}

