/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.properties.arbitraries.Range;
import net.jqwik.engine.properties.shrinking.AbstractShrinkable;
import net.jqwik.engine.properties.shrinking.BigDecimalShrinkingCandidates;
import net.jqwik.engine.properties.shrinking.ShrinkableBigInteger;

public class ShrinkableBigDecimal
extends AbstractShrinkable<BigDecimal> {
    private final int scale;
    private final Range<BigDecimal> range;
    private final BigDecimal target;
    private final BigDecimalShrinkingCandidates shrinkingCandidates;

    public ShrinkableBigDecimal(BigDecimal value, Range<BigDecimal> range, int scale) {
        super(value);
        this.range = range;
        this.scale = scale;
        this.target = this.determineTarget(value);
        this.shrinkingCandidates = new BigDecimalShrinkingCandidates(this.range, this.target);
    }

    @Override
    public Set<Shrinkable<BigDecimal>> shrinkCandidatesFor(Shrinkable<BigDecimal> shrinkable) {
        return this.shrinkingCandidates.candidatesFor((BigDecimal)shrinkable.value()).stream().map(aBigDecimal -> new ShrinkableBigDecimal((BigDecimal)aBigDecimal, this.range, this.scale)).collect(Collectors.toSet());
    }

    public ShrinkingDistance distance() {
        ShrinkingDistance bigIntegerDistance = ShrinkableBigInteger.distanceFor(((BigDecimal)this.value()).toBigInteger(), this.target.toBigInteger());
        BigDecimal fractionalPart = ((BigDecimal)this.value()).remainder(BigDecimal.ONE).abs();
        BigDecimal fractionalPartScaled = fractionalPart.scaleByPowerOfTen(this.scale);
        ShrinkingDistance decimalDistance = fractionalPartScaled.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) < 0 ? ShrinkingDistance.of((long[])new long[]{fractionalPartScaled.longValue()}) : ShrinkingDistance.of((long[])new long[]{Long.MAX_VALUE});
        return bigIntegerDistance.append(decimalDistance);
    }

    private BigDecimal determineTarget(BigDecimal value) {
        if (!this.range.includes(value)) {
            String message = String.format("Number <%s> is outside allowed range %s", value, this.range);
            throw new JqwikException(message);
        }
        if (this.range.includes(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            return (BigDecimal)this.range.max;
        }
        if (value.compareTo(BigDecimal.ZERO) > 0) {
            return (BigDecimal)this.range.min;
        }
        return value;
    }
}

