/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.properties.shrinking.AbstractShrinkable;

public class SampleShrinkable<T>
extends AbstractShrinkable<T> {
    private final List<T> samples;
    private final int index;

    @SafeVarargs
    public static <T> List<Shrinkable<T>> listOf(T ... samples) {
        List<T> samplesList = Arrays.asList(samples);
        ArrayList<Shrinkable<T>> shrinkables = new ArrayList<Shrinkable<T>>();
        for (int i = 0; i < samples.length; ++i) {
            shrinkables.add(new SampleShrinkable<T>(samplesList, i));
        }
        return shrinkables;
    }

    private SampleShrinkable(List<T> samples, int index) {
        super(samples.get(index));
        this.samples = samples;
        this.index = index;
    }

    @Override
    public Set<Shrinkable<T>> shrinkCandidatesFor(Shrinkable<T> shrinkable) {
        int sampleIndex = ((SampleShrinkable)shrinkable).index;
        if (sampleIndex == 0) {
            return Collections.emptySet();
        }
        return Collections.singleton(new SampleShrinkable<T>(this.samples, sampleIndex - 1));
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.of((long[])new long[]{this.index});
    }
}

