/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Reporting;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingMode;
import net.jqwik.engine.properties.shrinking.ElementsShrinkingSequence;
import net.jqwik.engine.properties.shrinking.PropertyShrinkingResult;
import net.jqwik.engine.support.JqwikStringSupport;
import org.junit.platform.engine.reporting.ReportEntry;

public class PropertyShrinker {
    private static final int BOUNDED_SHRINK_STEPS = 1000;
    private final List<Shrinkable> parameters;
    private final ShrinkingMode shrinkingMode;
    private final Consumer<ReportEntry> reporter;
    private final Reporting[] reporting;

    public PropertyShrinker(List<Shrinkable> parameters, ShrinkingMode shrinkingMode, Consumer<ReportEntry> reporter, Reporting[] reporting) {
        this.parameters = parameters;
        this.shrinkingMode = shrinkingMode;
        this.reporter = reporter;
        this.reporting = reporting;
    }

    public PropertyShrinkingResult shrink(Falsifier<List> forAllFalsifier, Throwable originalError) {
        if (this.shrinkingMode == ShrinkingMode.OFF) {
            return new PropertyShrinkingResult(this.toValues(this.parameters), 0, originalError);
        }
        Function distanceFunction = ShrinkingDistance::combine;
        ElementsShrinkingSequence sequence = new ElementsShrinkingSequence(this.parameters, forAllFalsifier, distanceFunction);
        sequence.init(FalsificationResult.falsified((Shrinkable)Shrinkable.unshrinkable((Object)this.toValues(this.parameters)), (Throwable)originalError));
        Consumer falsifiedReporter = this.isFalsifiedReportingOn() ? this::reportFalsifiedParams : ignore -> {};
        AtomicInteger shrinkingStepsCounter = new AtomicInteger(0);
        while (sequence.next(shrinkingStepsCounter::incrementAndGet, falsifiedReporter)) {
            if (this.shrinkingMode != ShrinkingMode.BOUNDED || shrinkingStepsCounter.get() < 1000) continue;
            this.reportShrinkingBoundReached(shrinkingStepsCounter.get(), this.toValues(this.parameters), sequence.current().value());
            break;
        }
        FalsificationResult current = sequence.current();
        return new PropertyShrinkingResult((List)current.value(), shrinkingStepsCounter.get(), current.throwable().orElse(null));
    }

    private boolean isFalsifiedReportingOn() {
        return Reporting.FALSIFIED.containedIn(this.reporting);
    }

    private List toValues(List<Shrinkable> shrinkables) {
        return shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    private void reportFalsifiedParams(FalsificationResult result) {
        ReportEntry falsifiedEntry = ReportEntry.from((String)"falsified", (String)JqwikStringSupport.displayString(result.value()));
        this.reporter.accept(falsifiedEntry);
    }

    private void reportShrinkingBoundReached(int steps, Object originalValue, Object bestShrunkValue) {
        String value = String.format("%n    steps : %s%n    original parameters : %s%n    shrunk parameters   : %s%nYou can switch on full shrinking with '@Property(shrinking = ShrinkingMode.FULL)'", steps, JqwikStringSupport.displayString(originalValue), JqwikStringSupport.displayString(bestShrunkValue));
        this.reporter.accept(ReportEntry.from((String)"shrinking bound reached", (String)value));
    }
}

