/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.function.Function;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;

public class MappedShrinkable<T, U>
implements Shrinkable<U> {
    private final Shrinkable<T> toMap;
    private final Function<T, U> mapper;

    public MappedShrinkable(Shrinkable<T> toMap, Function<T, U> mapper) {
        this.toMap = toMap;
        this.mapper = mapper;
    }

    public U value() {
        return this.mapper.apply(this.toMap.value());
    }

    public ShrinkingSequence<U> shrink(Falsifier<U> falsifier) {
        Falsifier toMapFalsifier = aT -> falsifier.test(this.mapper.apply(aT));
        return this.toMap.shrink(toMapFalsifier).map(result -> result.map(shrinkable -> shrinkable.map(this.mapper)));
    }

    public ShrinkingDistance distance() {
        return this.toMap.distance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedShrinkable that = (MappedShrinkable)o;
        return this.toMap.equals(that.toMap);
    }

    public int hashCode() {
        return this.toMap.hashCode();
    }

    public String toString() {
        return String.format("Mapped<%s>(%s)|%s", this.value().getClass().getSimpleName(), this.value(), this.toMap);
    }
}

