/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jqwik.engine.properties.shrinking.ShrinkingCandidates;

public class ListShrinkingCandidates<T>
implements ShrinkingCandidates<List<T>> {
    private final int minSize;

    public ListShrinkingCandidates(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public Set<List<T>> candidatesFor(List<T> toShrink) {
        if (toShrink.size() <= this.minSize) {
            return Collections.emptySet();
        }
        HashSet<List<T>> lists = new HashSet<List<T>>();
        this.appendRightCut(toShrink, lists);
        this.appendLeftCut(toShrink, lists);
        return lists;
    }

    private void appendLeftCut(List<T> toShrink, Set<List<T>> lists) {
        ArrayList<T> leftCut = new ArrayList<T>(toShrink);
        int elementsToCut = this.calculateElementsToCut(toShrink.size());
        this.cutFromLeft(leftCut, elementsToCut);
        lists.add(leftCut);
    }

    private int calculateElementsToCut(int listSize) {
        int toCut = this.rawElementsToCut(listSize);
        return Math.min(toCut, listSize - this.minSize);
    }

    private int rawElementsToCut(int listSize) {
        if (listSize <= 10) {
            return 1;
        }
        if (listSize < 20) {
            return listSize - 9;
        }
        return listSize / 2;
    }

    private void cutFromLeft(List<T> leftCut, int elementsToCut) {
        if (elementsToCut == 0) {
            return;
        }
        leftCut.remove(0);
        this.cutFromLeft(leftCut, --elementsToCut);
    }

    private void appendRightCut(List<T> toShrink, Set<List<T>> lists) {
        ArrayList<T> rightCut = new ArrayList<T>(toShrink);
        int elementsToCut = this.calculateElementsToCut(toShrink.size());
        this.cutFromRight(rightCut, elementsToCut);
        lists.add(rightCut);
    }

    private void cutFromRight(List<T> rightCut, int elementsToCut) {
        if (elementsToCut == 0) {
            return;
        }
        rightCut.remove(rightCut.size() - 1);
        this.cutFromRight(rightCut, --elementsToCut);
    }
}

