/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Falsifier;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;

public class FlatMappedShrinkable<T, U>
implements Shrinkable<U> {
    private final Shrinkable<T> toMap;
    private final Function<T, RandomGenerator<U>> mapper;
    private final long randomSeed;
    private final Shrinkable<U> shrinkable;

    public FlatMappedShrinkable(Shrinkable<T> toMap, Function<T, Arbitrary<U>> mapper, int genSize, long randomSeed) {
        this(toMap, value -> ((Arbitrary)mapper.apply(value)).generator(genSize), randomSeed);
    }

    public FlatMappedShrinkable(Shrinkable<T> toMap, Function<T, RandomGenerator<U>> mapper, long randomSeed) {
        this.toMap = toMap;
        this.mapper = mapper;
        this.randomSeed = randomSeed;
        this.shrinkable = this.generateShrinkable(toMap.value());
    }

    private Shrinkable<U> generateShrinkable(T value) {
        RandomGenerator<U> generator = this.mapper.apply(value);
        return generator.next(new Random(this.randomSeed));
    }

    public ShrinkingSequence<U> shrink(Falsifier<U> falsifier) {
        Falsifier toMapFalsifier = aT -> falsifier.test(this.generateShrinkable(aT).value());
        return this.toMap.shrink(toMapFalsifier).map(result -> result.map(shrinkableT -> new FlatMappedShrinkable<T, U>(result.shrinkable(), this.mapper, this.randomSeed))).andThen(aShrinkable -> {
            FlatMappedShrinkable flatMappedShrinkable = (FlatMappedShrinkable)aShrinkable;
            return flatMappedShrinkable.shrinkable.shrink(falsifier);
        });
    }

    public U value() {
        return (U)this.shrinkable.value();
    }

    public ShrinkingDistance distance() {
        return this.toMap.distance().append(this.shrinkable.distance());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlatMappedShrinkable)) {
            return false;
        }
        FlatMappedShrinkable that = (FlatMappedShrinkable)o;
        return Objects.equals(this.shrinkable.value(), that.value());
    }

    public int hashCode() {
        return Objects.hash(this.shrinkable.value());
    }

    public String toString() {
        return String.format("FlatMapped<%s>(%s)|%s", this.value().getClass().getSimpleName(), this.value(), this.toMap);
    }
}

