/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;

public class ElementsShrinkingSequence<T>
implements ShrinkingSequence<List<T>> {
    private final Falsifier<List<T>> listFalsifier;
    private final List<FalsificationResult<T>> currentResults;
    private final Function<List<Shrinkable<T>>, ShrinkingDistance> distanceFunction;
    private int currentShrinkingPosition = 0;
    private ShrinkingSequence<T> currentShrinkingSequence = null;
    private Throwable currentThrowable;

    public ElementsShrinkingSequence(List<Shrinkable<T>> currentElements, Falsifier<List<T>> listFalsifier, Function<List<Shrinkable<T>>, ShrinkingDistance> distanceFunction) {
        this.currentResults = currentElements.stream().map(FalsificationResult::falsified).collect(Collectors.toList());
        this.listFalsifier = listFalsifier;
        this.distanceFunction = distanceFunction;
    }

    public void init(FalsificationResult<List<T>> initialCurrent) {
        this.currentThrowable = initialCurrent.throwable().orElse(null);
        for (int i = 0; i < this.currentResults.size(); ++i) {
            FalsificationResult newResult = FalsificationResult.falsified((Shrinkable)this.currentResults.get(i).shrinkable(), (Throwable)this.currentThrowable);
            this.currentResults.set(i, newResult);
        }
    }

    public boolean next(Runnable count, Consumer<FalsificationResult<List<T>>> falsifiedReporter) {
        if (this.isShrinkingDone()) {
            return false;
        }
        return this.shrinkCurrentPosition(count, falsifiedReporter);
    }

    private boolean isShrinkingDone() {
        return this.currentShrinkingPosition >= this.currentResults.size();
    }

    private boolean shrinkCurrentPosition(Runnable count, Consumer<FalsificationResult<List<T>>> falsifiedReporter) {
        if (this.currentShrinkingSequence == null) {
            this.currentShrinkingSequence = this.createShrinkingSequence(this.currentShrinkingPosition);
        }
        if (!this.currentShrinkingSequence.next(count, this.currentFalsifiedReporter(falsifiedReporter))) {
            return this.advanceToNextShrinkingPosition(count, falsifiedReporter);
        }
        this.replaceCurrentPosition(this.currentShrinkingSequence.current());
        return true;
    }

    private boolean advanceToNextShrinkingPosition(Runnable count, Consumer<FalsificationResult<List<T>>> falsifiedReporter) {
        this.currentShrinkingSequence = null;
        ++this.currentShrinkingPosition;
        return this.next(count, falsifiedReporter);
    }

    private Consumer<FalsificationResult<T>> currentFalsifiedReporter(Consumer<FalsificationResult<List<T>>> listReporter) {
        if (this.isShrinkingDone()) {
            return ignore -> {};
        }
        return resultOnCurrentShrinkingPosition -> listReporter.accept(resultOnCurrentShrinkingPosition.map(shrinkable -> shrinkable.map(valueOnCurrentShrinkingPosition -> {
            List<T> values = this.toValueList(this.currentResults);
            values.set(this.currentShrinkingPosition, resultOnCurrentShrinkingPosition.value());
            return values;
        })));
    }

    private void replaceCurrentPosition(FalsificationResult<T> falsificationResult) {
        this.currentResults.set(this.currentShrinkingPosition, falsificationResult);
        this.currentThrowable = falsificationResult.throwable().orElse(null);
    }

    private ShrinkingSequence<T> createShrinkingSequence(int position) {
        FalsificationResult<T> positionResult = this.currentResults.get(position);
        Falsifier<T> positionFalsifier = this.falsifierForPosition(position, this.currentResults);
        return positionResult.shrinkable().shrink(positionFalsifier);
    }

    private Falsifier<T> falsifierForPosition(int position, List<FalsificationResult<T>> falsificationResults) {
        return elementValue -> {
            List<T> effectiveParams = this.toValueList(falsificationResults);
            effectiveParams.set(position, elementValue);
            return this.listFalsifier.test(effectiveParams);
        };
    }

    public FalsificationResult<List<T>> current() {
        return FalsificationResult.falsified(this.createCurrent(this.currentResults), (Throwable)this.currentThrowable);
    }

    private Shrinkable<List<T>> createCurrent(final List<FalsificationResult<T>> falsificationResults) {
        return new Shrinkable<List<T>>(){

            public List<T> value() {
                return ElementsShrinkingSequence.this.toValueList(falsificationResults);
            }

            public ShrinkingSequence<List<T>> shrink(Falsifier<List<T>> falsifier) {
                return ElementsShrinkingSequence.this;
            }

            public ShrinkingDistance distance() {
                return (ShrinkingDistance)ElementsShrinkingSequence.this.distanceFunction.apply(ElementsShrinkingSequence.this.toShrinkableList(falsificationResults));
            }
        };
    }

    private List<T> toValueList(List<FalsificationResult<T>> results) {
        return results.stream().map(FalsificationResult::value).collect(Collectors.toList());
    }

    private List<Shrinkable<T>> toShrinkableList(List<FalsificationResult<T>> results) {
        return results.stream().map(FalsificationResult::shrinkable).collect(Collectors.toList());
    }
}

