/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.engine.properties.shrinking.ElementsShrinkingSequence;

public class CombinedShrinkable<T>
implements Shrinkable<T> {
    private final List<Shrinkable<Object>> shrinkables;
    private final Function<List<Object>, T> combinator;

    public CombinedShrinkable(List<Shrinkable<Object>> shrinkables, Function<List<Object>, T> combinator) {
        this.shrinkables = shrinkables;
        this.combinator = combinator;
    }

    public T value() {
        return this.combinator.apply(this.toValues(this.shrinkables));
    }

    private List<Object> toValues(List<Shrinkable<Object>> shrinkables) {
        return shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    public ShrinkingSequence<T> shrink(Falsifier<T> falsifier) {
        return new CombinedShrinkingSequence(falsifier);
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.combine(this.shrinkables);
    }

    private class CombinedShrinkingSequence
    implements ShrinkingSequence<T> {
        private final ElementsShrinkingSequence<Object> elementsSequence;

        private CombinedShrinkingSequence(Falsifier<T> falsifier) {
            Falsifier combinedFalsifier = elements -> falsifier.test(CombinedShrinkable.this.combinator.apply(elements));
            this.elementsSequence = new ElementsShrinkingSequence(CombinedShrinkable.this.shrinkables, combinedFalsifier, ShrinkingDistance::combine);
        }

        public void init(FalsificationResult<T> initialCurrent) {
            this.elementsSequence.init((FalsificationResult<List<Object>>)FalsificationResult.falsified((Shrinkable)Shrinkable.unshrinkable(new ArrayList()), (Throwable)initialCurrent.throwable().orElse(null)));
        }

        public boolean next(Runnable count, Consumer<FalsificationResult<T>> falsifiedReporter) {
            Consumer combinedReporter = result -> falsifiedReporter.accept(result.map(shrinkable -> shrinkable.map(CombinedShrinkable.this.combinator)));
            return this.elementsSequence.next(count, combinedReporter);
        }

        public FalsificationResult<T> current() {
            return this.elementsSequence.current().map(shrinkable -> shrinkable.map(CombinedShrinkable.this.combinator));
        }
    }
}

