/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import net.jqwik.engine.properties.shrinking.ShrinkingCandidates;

public class BigIntegerShrinkingCandidates
implements ShrinkingCandidates<BigInteger> {
    private final BigInteger shrinkingTarget;

    public BigIntegerShrinkingCandidates(BigInteger shrinkingTarget) {
        this.shrinkingTarget = shrinkingTarget;
    }

    @Override
    public Set<BigInteger> candidatesFor(BigInteger value) {
        HashSet<BigInteger> candidates = new HashSet<BigInteger>();
        BigInteger lower = this.shrinkingTarget.min(value);
        BigInteger higher = this.shrinkingTarget.max(value);
        this.addFibbonaci(candidates, lower, BigInteger.valueOf(0L), BigInteger.valueOf(1L), higher);
        this.subFibbonaci(candidates, higher, BigInteger.valueOf(0L), BigInteger.valueOf(1L), lower);
        candidates.add(this.shrinkingTarget);
        candidates.remove(value);
        return candidates;
    }

    private void subFibbonaci(Set<BigInteger> candidates, BigInteger target, BigInteger butLast, BigInteger last, BigInteger border) {
        BigInteger step;
        BigInteger candidate;
        while ((candidate = target.subtract(step = butLast.add(last))).compareTo(border) > 0) {
            candidates.add(candidate);
            butLast = last;
            last = step;
        }
    }

    private void addFibbonaci(Set<BigInteger> candidates, BigInteger target, BigInteger butLast, BigInteger last, BigInteger border) {
        BigInteger step;
        BigInteger candidate;
        while ((candidate = target.add(step = butLast.add(last))).compareTo(border) < 0) {
            candidates.add(candidate);
            butLast = last;
            last = step;
        }
    }
}

